/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.UnitNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.IntTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.graph.EdgeByUniqueExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class EdgeByUniqueExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode unique;
    private ExprNode edgeType;

    public EdgeByUniqueExprNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords);
        this.unique = exprNode;
        this.becomeParent(this.unique);
        this.edgeType = exprNode2;
        this.becomeParent(this.edgeType);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.unique);
        vector.add(this.edgeType);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("unique");
        vector.add("edgeType");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        if (!(this.unique.getType() instanceof IntTypeNode)) {
            this.reportError("The function edgeByUnique expects as 1. argument (uniqueIdToSearchFor) a value of type int (but is given a value of type " + this.unique.getType().getTypeName() + ").");
            return false;
        }
        if (!(this.edgeType.getType() instanceof EdgeTypeNode)) {
            this.reportError("The function edgeByUnique expects as 2. argument (typeToObtain) a value of type edge type (but is given a value of type " + this.edgeType.getType().getTypeName() + ").");
            return false;
        }
        if (!UnitNode.getRoot().getModel().IsUniqueIndexDefined()) {
            this.reportError("The function edgeByUnique expects a model with a unique index, but the required index unique; declaration is missing in the model specification.");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.unique = this.unique.evaluate();
        this.edgeType = this.edgeType.evaluate();
        return new EdgeByUniqueExpr(this.unique.checkIR(Expression.class), this.edgeType.checkIR(Expression.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        return this.edgeType.getType();
    }

    static {
        EdgeByUniqueExprNode.setName(EdgeByUniqueExprNode.class, "edge by unique expr");
    }
}

