/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.UnitNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.graph.Graphof;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class GraphofExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode entity;

    public GraphofExprNode(Coords coords, ExprNode exprNode) {
        super(coords);
        this.entity = exprNode;
        this.becomeParent(this.entity);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.entity);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("entity");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (this.entity.getType() instanceof NodeTypeNode || this.entity.getType() instanceof EdgeTypeNode) {
            if (!UnitNode.getRoot().getModel().IsGraphofDefined()) {
                String string = this.entity.getType() instanceof NodeTypeNode ? "node" : "edge";
                this.reportError("The function graphof applied to an argument of " + string + " type expects a model with graph containment support, but the required node edge graph; declaration is missing in the model specification.");
                return false;
            }
            return true;
        }
        this.reportError("The function graphof expects as argument (entityToFetchContainingGraphOf) a value of type node or edge (but is given a value of type " + this.entity.getType().getTypeName() + ").");
        return false;
    }

    @Override
    protected IR constructIR() {
        this.entity = this.entity.evaluate();
        return new Graphof(this.entity.checkIR(Expression.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.graphType;
    }

    static {
        GraphofExprNode.setName(GraphofExprNode.class, "graphof");
    }
}

