/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.StringTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.graph.NodeByNameExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class NodeByNameExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode name;
    private ExprNode nodeType;

    public NodeByNameExprNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords);
        this.name = exprNode;
        this.becomeParent(this.name);
        this.nodeType = exprNode2;
        this.becomeParent(this.nodeType);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.name);
        vector.add(this.nodeType);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("name");
        vector.add("nodeType");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        if (!(this.name.getType() instanceof StringTypeNode)) {
            this.reportError("The function nodeByName expects as 1. argument (nameToSearchFor) a value of type string (but is given a value of type " + this.name.getType().getTypeName() + ").");
            return false;
        }
        if (!(this.nodeType.getType() instanceof NodeTypeNode)) {
            this.reportError("The function nodeByName expects as 2. argument (typeToObain) a value of type node type (but is given a value of type " + this.nodeType.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.name = this.name.evaluate();
        this.nodeType = this.nodeType.evaluate();
        return new NodeByNameExpr(this.name.checkIR(Expression.class), this.nodeType.checkIR(Expression.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        return this.nodeType.getType();
    }

    static {
        NodeByNameExprNode.setName(NodeByNameExprNode.class, "node by name expr");
    }
}

