/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.UnitNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.IntTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.graph.NodeByUniqueExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class NodeByUniqueExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode unique;
    private ExprNode nodeType;

    public NodeByUniqueExprNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords);
        this.unique = exprNode;
        this.becomeParent(this.unique);
        this.nodeType = exprNode2;
        this.becomeParent(this.nodeType);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.unique);
        vector.add(this.nodeType);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("name");
        vector.add("nodeType");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        if (!(this.unique.getType() instanceof IntTypeNode)) {
            this.reportError("The function nodeByUnique expects as 1. argument (uniqueIdToSearchFor) a value of type int (but is given a value of type " + this.unique.getType().getTypeName() + ").");
            return false;
        }
        if (!(this.nodeType.getType() instanceof NodeTypeNode)) {
            this.reportError("The function nodeByUnique expects as 2. argument (typeToObtain) a value of type node type (but is given a value of type " + this.nodeType.getType().getTypeName() + ").");
            return false;
        }
        if (!UnitNode.getRoot().getModel().IsUniqueIndexDefined()) {
            this.reportError("The function nodeByUnique expects a model with a unique index, but the required index unique; declaration is missing in the model specification.");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.unique = this.unique.evaluate();
        this.nodeType = this.nodeType.evaluate();
        return new NodeByUniqueExpr(this.unique.checkIR(Expression.class), this.nodeType.checkIR(Expression.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        return this.nodeType.getType();
    }

    static {
        NodeByUniqueExprNode.setName(NodeByUniqueExprNode.class, "node by unique expr");
    }
}

