/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.UnitNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.graph.Uniqueof;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class UniqueofExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode entity;

    public UniqueofExprNode(Coords coords, ExprNode exprNode) {
        super(coords);
        this.entity = exprNode;
        this.becomeParent(this.entity);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        if (this.entity != null) {
            vector.add(this.entity);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        if (this.entity != null) {
            vector.add("entity");
        }
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (this.entity != null) {
            if (this.entity.getType().isEqual(BasicTypeNode.graphType)) {
                return true;
            }
            if (this.entity.getType() instanceof EdgeTypeNode) {
                if (!UnitNode.getRoot().getModel().IsUniqueDefined() && !UnitNode.getRoot().getModel().IsUniqueIndexDefined()) {
                    this.reportError("The function uniqueof applied to an argument of edge type expects a model with uniqueId support, but the required node edge unique; declaration is missing in the model specification.");
                    return false;
                }
                return true;
            }
            if (this.entity.getType() instanceof NodeTypeNode) {
                if (!UnitNode.getRoot().getModel().IsUniqueDefined() && !UnitNode.getRoot().getModel().IsUniqueIndexDefined()) {
                    this.reportError("The function uniqueof applied to an argument of node type expects a model with uniqueId support, but the required node edge unique; declaration is missing in the model specification.");
                    return false;
                }
                return true;
            }
            if (this.entity.getType() instanceof InternalObjectTypeNode) {
                if (!UnitNode.getRoot().getModel().IsUniqueClassDefined()) {
                    this.reportError("The function uniqueof applied to an argument of (object) class type expects a model with uniqueId support, but the required object class unique; declaration is missing in the model specification.");
                    return false;
                }
                return true;
            }
            this.reportError("The function uniqueof expects as argument (entityToFetchUniqueIdOf) a value of type node or edge or graph or internal class object (but is given a value of type " + this.entity.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        if (this.entity == null) {
            return new Uniqueof(null, this.getType().getType());
        }
        this.entity = this.entity.evaluate();
        return new Uniqueof(this.entity.checkIR(Expression.class), this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        if (this.entity != null && this.entity.getType() instanceof InternalObjectTypeNode) {
            return BasicTypeNode.longType;
        }
        return BasicTypeNode.intType;
    }

    static {
        UniqueofExprNode.setName(UniqueofExprNode.class, "uniqueof");
    }
}

