/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.invocation;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.ScopeOwner;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.invocation.FunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Function;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.invocation.FunctionMethodInvocationExpr;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Vector;

public class FunctionMethodInvocationExprNode
extends FunctionInvocationBaseNode {
    private IdentNode ownerUnresolved;
    private DeclNode owner;
    private IdentNode functionUnresolved;
    private FunctionDeclNode functionDecl;
    private static final DeclarationResolver<DeclNode> ownerResolver;
    private static final DeclarationResolver<FunctionDeclNode> resolver;

    public FunctionMethodInvocationExprNode(IdentNode identNode, IdentNode identNode2, CollectNode<ExprNode> collectNode) {
        super(identNode2.getCoords(), collectNode);
        this.ownerUnresolved = this.becomeParent(identNode);
        this.functionUnresolved = this.becomeParent(identNode2);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.ownerUnresolved, this.owner));
        vector.add(this.getValidVersion(this.functionUnresolved, this.functionDecl));
        vector.add(this.arguments);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("owner");
        vector.add("function method");
        vector.add("arguments");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl;
        boolean bl2 = FunctionMethodInvocationExprNode.fixupDefinition(this.ownerUnresolved, this.ownerUnresolved.getScope());
        if (!bl2) {
            return false;
        }
        boolean bl3 = true;
        this.owner = (DeclNode)ownerResolver.resolve(this.ownerUnresolved, this);
        bl3 = this.owner != null && bl3;
        boolean bl4 = bl = this.owner != null && this.owner.resolve();
        if (!bl) {
            return false;
        }
        if (bl && this.owner != null && (this.owner instanceof NodeDeclNode || this.owner instanceof EdgeDeclNode || this.owner instanceof VarDeclNode)) {
            TypeNode typeNode = this.owner.getDeclType();
            if (typeNode instanceof ScopeOwner) {
                ScopeOwner scopeOwner = (ScopeOwner)((Object)typeNode);
                bl2 = scopeOwner.fixupDefinition(this.functionUnresolved);
                this.functionDecl = (FunctionDeclNode)resolver.resolve(this.functionUnresolved, this);
                if (this.functionDecl == null) {
                    this.functionUnresolved.reportError("A function method of name " + this.functionUnresolved + " is not known. Is it a misspelled function name? Or is a procedure call intended (this is not possible in an expression, an assignment target must be given as (param,...)=call in that case)?");
                    return false;
                }
                bl3 = this.functionDecl != null && bl3;
            } else {
                this.reportError("Left hand side of '.' does not own a scope.");
                bl3 = false;
            }
        } else {
            this.reportError("Left hand side of '.' is neither a node nor an edge nor a variable" + (this.owner != null && this.owner.getDeclType() != null ? " (type " + this.owner.getDeclType().toStringWithDeclarationCoords() + ")." : "."));
            bl3 = false;
        }
        return bl3;
    }

    @Override
    protected boolean checkLocal() {
        return this.checkSignatureAdhered(this.functionDecl, this.functionUnresolved, true);
    }

    @Override
    public TypeNode getType() {
        assert (this.isResolved());
        return this.functionDecl.getResultType();
    }

    @Override
    protected IR constructIR() {
        FunctionMethodInvocationExpr functionMethodInvocationExpr = new FunctionMethodInvocationExpr(this.owner.checkIR(Entity.class), this.functionDecl.resultType.checkIR(Type.class), this.functionDecl.checkIR(Function.class));
        for (ExprNode exprNode : this.arguments.getChildren()) {
            exprNode = exprNode.evaluate();
            functionMethodInvocationExpr.addArgument(exprNode.checkIR(Expression.class));
        }
        return functionMethodInvocationExpr;
    }

    static {
        FunctionMethodInvocationExprNode.setName(FunctionMethodInvocationExprNode.class, "function method invocation expression");
        ownerResolver = new DeclarationResolver<DeclNode>(DeclNode.class);
        resolver = new DeclarationResolver<FunctionDeclNode>(FunctionDeclNode.class);
    }
}

