/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.invocation;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.executable.ExternalFunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclBaseNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.invocation.FunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationPairResolver;
import de.unika.ipd.grgen.ast.util.Pair;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.ExternalFunction;
import de.unika.ipd.grgen.ir.executable.Function;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.invocation.ExternalFunctionInvocationExpr;
import de.unika.ipd.grgen.ir.expr.invocation.FunctionInvocationExpr;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Vector;

public class FunctionOrExternalFunctionInvocationExprNode
extends FunctionInvocationBaseNode {
    private IdentNode functionOrExternalFunctionUnresolved;
    private ExternalFunctionDeclNode externalFunctionDecl;
    private FunctionDeclNode functionDecl;
    private static final DeclarationPairResolver<FunctionDeclNode, ExternalFunctionDeclNode> resolver;

    public FunctionOrExternalFunctionInvocationExprNode(IdentNode identNode, CollectNode<ExprNode> collectNode) {
        super(identNode.getCoords(), collectNode);
        this.functionOrExternalFunctionUnresolved = this.becomeParent(identNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.functionOrExternalFunctionUnresolved, this.functionDecl, this.externalFunctionDecl));
        vector.add(this.arguments);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("function or external function");
        vector.add("arguments");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        Object object;
        if (!(this.functionOrExternalFunctionUnresolved instanceof PackageIdentNode)) {
            FunctionOrExternalFunctionInvocationExprNode.fixupDefinition(this.functionOrExternalFunctionUnresolved, this.functionOrExternalFunctionUnresolved.getScope());
        }
        if ((object = resolver.resolve(this.functionOrExternalFunctionUnresolved, this)) == null) {
            this.functionOrExternalFunctionUnresolved.reportError("A function/external function of name " + this.functionOrExternalFunctionUnresolved + " is not known. Is it a misspelled (external) function name? Or is a procedure call intended (this is not possible in an expression, an assignment target must be given as (param,...)=call in that case)?");
            return false;
        }
        this.functionDecl = (FunctionDeclNode)((Pair)object).fst;
        this.externalFunctionDecl = (ExternalFunctionDeclNode)((Pair)object).snd;
        return true;
    }

    @Override
    protected boolean checkLocal() {
        FunctionDeclBaseNode functionDeclBaseNode = this.functionDecl != null ? this.functionDecl : this.externalFunctionDecl;
        return this.checkSignatureAdhered(functionDeclBaseNode, this.functionOrExternalFunctionUnresolved, false);
    }

    @Override
    public TypeNode getType() {
        assert (this.isResolved());
        return this.functionDecl != null ? this.functionDecl.getResultType() : this.externalFunctionDecl.getResultType();
    }

    @Override
    protected IR constructIR() {
        if (this.functionDecl != null) {
            FunctionInvocationExpr functionInvocationExpr = new FunctionInvocationExpr(this.functionDecl.resultType.checkIR(Type.class), this.functionDecl.checkIR(Function.class));
            for (ExprNode exprNode : this.arguments.getChildren()) {
                exprNode = exprNode.evaluate();
                functionInvocationExpr.addArgument(exprNode.checkIR(Expression.class));
            }
            return functionInvocationExpr;
        }
        ExternalFunctionInvocationExpr externalFunctionInvocationExpr = new ExternalFunctionInvocationExpr(this.externalFunctionDecl.resultType.checkIR(Type.class), this.externalFunctionDecl.checkIR(ExternalFunction.class));
        for (ExprNode exprNode : this.arguments.getChildren()) {
            exprNode = exprNode.evaluate();
            externalFunctionInvocationExpr.addArgument(exprNode.checkIR(Expression.class));
        }
        return externalFunctionInvocationExpr;
    }

    static {
        FunctionOrExternalFunctionInvocationExprNode.setName(FunctionOrExternalFunctionInvocationExprNode.class, "function or external function invocation expression");
        resolver = new DeclarationPairResolver<FunctionDeclNode, ExternalFunctionDeclNode>(FunctionDeclNode.class, ExternalFunctionDeclNode.class);
    }
}

