/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.invocation;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CallActionNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.MultiCallActionNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.invocation.RuleQueryExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.invocation.MultiRuleQueryExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class MultiRuleQueryExprNode
extends ExprNode {
    private CollectNode<ExprNode> ruleQueries;
    private IdentNode matchClass;
    private TypeNode arrayOfMatchTypeUnresolved;
    private TypeNode arrayOfMatchType;

    public MultiRuleQueryExprNode(Coords coords, CollectNode<ExprNode> collectNode, IdentNode identNode, TypeNode typeNode) {
        super(coords);
        this.ruleQueries = this.becomeParent(collectNode);
        this.matchClass = this.becomeParent(identNode);
        this.arrayOfMatchTypeUnresolved = this.becomeParent(typeNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ruleQueries);
        vector.add(this.matchClass);
        vector.add(this.getValidVersion(this.arrayOfMatchTypeUnresolved, this.arrayOfMatchType));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ruleQueries");
        vector.add("matchClass");
        vector.add("arrayOfMatchType");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (this.arrayOfMatchTypeUnresolved.resolve()) {
            this.arrayOfMatchType = this.arrayOfMatchTypeUnresolved;
        }
        return this.arrayOfMatchType != null;
    }

    @Override
    protected boolean checkLocal() {
        for (ExprNode exprNode : this.ruleQueries.getChildren()) {
            CallActionNode callActionNode = ((RuleQueryExprNode)exprNode).getCallAction();
            MultiCallActionNode.checkWhetherCalledActionImplementsMatchClass(this.matchClass.getIdent().toString(), null, callActionNode);
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        return new MultiRuleQueryExpr(this.getType().getType());
    }

    @Override
    public TypeNode getType() {
        return this.arrayOfMatchType;
    }

    static {
        MultiRuleQueryExprNode.setName(MultiRuleQueryExprNode.class, "multi rule query");
    }
}

