/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.invocation;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.invocation.FunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.invocation.FunctionInvocationDecisionNode;
import de.unika.ipd.grgen.ast.expr.numeric.AbsExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.ArcSinCosTanExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.ByteMaxExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.ByteMinExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.CeilExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.DoubleMaxExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.DoubleMinExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.EExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.FloatMaxExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.FloatMinExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.FloorExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.IntMaxExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.IntMinExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.LogExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.LongMaxExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.LongMinExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.MaxExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.MinExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.PiExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.PowExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.RoundExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.SgnExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.ShortMaxExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.ShortMinExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.SinCosTanExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.SqrExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.SqrtExprNode;
import de.unika.ipd.grgen.ast.expr.numeric.TruncateExprNode;
import de.unika.ipd.grgen.ast.expr.procenv.ExistsFileExprNode;
import de.unika.ipd.grgen.ast.expr.procenv.ImportExprNode;
import de.unika.ipd.grgen.ast.expr.procenv.NowExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.executable.FunctionTypeNode;
import de.unika.ipd.grgen.ast.util.ResolvingEnvironment;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.parser.ParserEnvironment;
import java.util.Collection;
import java.util.Vector;

public class PackageFunctionInvocationDecisionNode
extends FunctionInvocationBaseNode {
    static TypeNode functionTypeNode;
    public String package_;
    public IdentNode functionIdent;
    private BuiltinFunctionInvocationBaseNode result;
    ParserEnvironment env;

    public PackageFunctionInvocationDecisionNode(String string, IdentNode identNode, CollectNode<ExprNode> collectNode, ParserEnvironment parserEnvironment) {
        super(identNode.getCoords(), collectNode);
        this.package_ = string;
        this.functionIdent = this.becomeParent(identNode);
        this.env = parserEnvironment;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.arguments);
        if (this.isResolved()) {
            vector.add(this.result);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("params");
        if (this.isResolved()) {
            vector.add("result");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        ResolvingEnvironment resolvingEnvironment = new ResolvingEnvironment(null, error, this.getCoords());
        this.result = PackageFunctionInvocationDecisionNode.decide(this.package_ + "::" + this.functionIdent.toString(), this.arguments, resolvingEnvironment);
        return this.result != null;
    }

    private static BuiltinFunctionInvocationBaseNode decide(String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "Math::min": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("Math::min() expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new MinExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1));
            }
            case "Math::max": {
                if (collectNode.size() != 2) {
                    resolvingEnvironment.reportError("Math::max() expects 2 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new MaxExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1));
            }
            case "Math::sin": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Math::sin() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SinCosTanExprNode(resolvingEnvironment.getCoords(), SinCosTanExprNode.TrigonometryFunctionType.sin, collectNode.get(0));
            }
            case "Math::cos": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Math::cos() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SinCosTanExprNode(resolvingEnvironment.getCoords(), SinCosTanExprNode.TrigonometryFunctionType.cos, collectNode.get(0));
            }
            case "Math::tan": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Math::tan() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SinCosTanExprNode(resolvingEnvironment.getCoords(), SinCosTanExprNode.TrigonometryFunctionType.tan, collectNode.get(0));
            }
            case "Math::arcsin": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Math::arcsin() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArcSinCosTanExprNode(resolvingEnvironment.getCoords(), ArcSinCosTanExprNode.ArcusTrigonometryFunctionType.arcsin, collectNode.get(0));
            }
            case "Math::arccos": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Math::arccos() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArcSinCosTanExprNode(resolvingEnvironment.getCoords(), ArcSinCosTanExprNode.ArcusTrigonometryFunctionType.arccos, collectNode.get(0));
            }
            case "Math::arctan": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Math::arctan() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ArcSinCosTanExprNode(resolvingEnvironment.getCoords(), ArcSinCosTanExprNode.ArcusTrigonometryFunctionType.arctan, collectNode.get(0));
            }
            case "Math::sqr": {
                if (collectNode.size() == 1) {
                    return new SqrExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
                }
                resolvingEnvironment.reportError("Math::sqr() expects 1 argument (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "Math::sqrt": {
                if (collectNode.size() == 1) {
                    return new SqrtExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
                }
                resolvingEnvironment.reportError("Math::sqrt() expects 1 argument (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "Math::pow": {
                if (collectNode.size() == 2) {
                    return new PowExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1));
                }
                if (collectNode.size() == 1) {
                    return new PowExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
                }
                resolvingEnvironment.reportError("Math::pow() expects 1 or 2 arguments (one means base e) (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "Math::log": {
                if (collectNode.size() == 2) {
                    return new LogExprNode(resolvingEnvironment.getCoords(), collectNode.get(0), collectNode.get(1));
                }
                if (collectNode.size() == 1) {
                    return new LogExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
                }
                resolvingEnvironment.reportError("Math::log() expects 1 or 2 arguments (one means base e) (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "Math::abs": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Math::abs() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new AbsExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "Math::pi": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::pi() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new PiExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::e": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::e() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new EExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::byteMin": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::byteMin() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ByteMinExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::byteMax": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::byteMax() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ByteMaxExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::shortMin": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::shortMin() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ShortMinExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::shortMax": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::shortMax() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ShortMaxExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::intMin": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::intMin() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new IntMinExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::intMax": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::intMax() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new IntMaxExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::longMin": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::longMin() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new LongMinExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::longMax": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::longMax() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new LongMaxExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::floatMin": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::floatMin() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new FloatMinExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::floatMax": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::floatMax() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new FloatMaxExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::doubleMin": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::doubleMin() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new DoubleMinExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::doubleMax": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Math::doubleMax() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new DoubleMaxExprNode(resolvingEnvironment.getCoords());
            }
            case "Math::ceil": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Math::ceil() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new CeilExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "Math::floor": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Math::floor() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new FloorExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "Math::round": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Math::round() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new RoundExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "Math::truncate": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Math::truncate() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new TruncateExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "Math::sgn": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Math::sgn() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SgnExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "Time::now": {
                if (collectNode.size() > 0) {
                    resolvingEnvironment.reportError("Time::now() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new NowExprNode(resolvingEnvironment.getCoords());
            }
            case "File::exists": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("File::exists() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ExistsFileExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "File::import": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("File::import() expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ImportExprNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
        }
        resolvingEnvironment.reportError("A function of package::name " + string + " is not known.");
        return null;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public TypeNode getType() {
        return this.result.getType();
    }

    public ExprNode getResult() {
        return this.result;
    }

    @Override
    protected IR constructIR() {
        return this.result.getIR();
    }

    static {
        PackageFunctionInvocationDecisionNode.setName(FunctionInvocationDecisionNode.class, "package function invocation decision expression");
        functionTypeNode = new FunctionTypeNode();
    }
}

