/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.map;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.map.MapCopyConstructor;
import de.unika.ipd.grgen.ir.type.container.MapType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class MapCopyConstructorNode
extends ExprNode {
    private MapTypeNode mapType;
    private ExprNode mapToCopy;
    private BaseNode lhsUnresolved;

    public MapCopyConstructorNode(Coords coords, IdentNode identNode, MapTypeNode mapTypeNode, ExprNode exprNode) {
        super(coords);
        if (identNode != null) {
            this.lhsUnresolved = this.becomeParent(identNode);
        } else {
            this.mapType = mapTypeNode;
        }
        this.mapToCopy = exprNode;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.mapToCopy);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("mapToCopy");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (this.mapType != null) {
            return this.mapType.resolve();
        }
        return true;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = true;
        if (this.lhsUnresolved != null) {
            this.reportError("A map copy constructor is not allowed in a map initialization in the model.");
            bl = false;
        } else if (this.mapToCopy.getType() instanceof MapTypeNode) {
            MapTypeNode mapTypeNode = (MapTypeNode)this.mapToCopy.getType();
            bl &= this.checkCopyConstructorTypes(this.mapType.keyType, mapTypeNode.keyType, "map", true);
            bl &= this.checkCopyConstructorTypes(this.mapType.valueType, mapTypeNode.valueType, "map", false);
        } else {
            this.reportError("A map copy constructor expects a value of map type to copy (but is given " + this.mapToCopy.getType().getTypeName() + ").");
            bl = false;
        }
        return bl;
    }

    @Override
    public TypeNode getType() {
        assert (this.isResolved());
        return this.mapType;
    }

    @Override
    protected IR constructIR() {
        this.mapToCopy = this.mapToCopy.evaluate();
        return new MapCopyConstructor(this.mapToCopy.checkIR(Expression.class), this.mapType.checkIR(MapType.class));
    }

    public static String getKindStr() {
        return "map copy constructor";
    }

    static {
        MapCopyConstructorNode.setName(MapCopyConstructorNode.class, "map copy constructor");
    }
}

