/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.numeric;

import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.ByteConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.DoubleConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.IntConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.LongConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.ShortConstNode;
import de.unika.ipd.grgen.ast.expr.string.StringConstNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.parser.Coords;

public class FloatConstNode
extends ConstNode {
    public FloatConstNode(Coords coords, double d) {
        super(coords, "float", new Float(d));
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.floatType;
    }

    @Override
    protected ConstNode doCastTo(TypeNode typeNode) {
        Float f = (Float)this.getValue();
        float f2 = f.floatValue();
        if (typeNode.isEqual(BasicTypeNode.byteType)) {
            return new ByteConstNode(this.getCoords(), (byte)f2);
        }
        if (typeNode.isEqual(BasicTypeNode.shortType)) {
            return new ShortConstNode(this.getCoords(), (short)f2);
        }
        if (typeNode.isEqual(BasicTypeNode.intType)) {
            return new IntConstNode(this.getCoords(), (int)f2);
        }
        if (typeNode.isEqual(BasicTypeNode.longType)) {
            return new LongConstNode(this.getCoords(), (long)f2);
        }
        if (typeNode.isEqual(BasicTypeNode.doubleType)) {
            return new DoubleConstNode(this.getCoords(), f2);
        }
        if (typeNode.isEqual(BasicTypeNode.stringType)) {
            return new StringConstNode(this.getCoords(), f.toString());
        }
        throw new UnsupportedOperationException();
    }
}

