/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.numeric;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.numeric.FloorExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class FloorExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode argumentExpr;

    public FloorExprNode(Coords coords, ExprNode exprNode) {
        super(coords);
        this.argumentExpr = this.becomeParent(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.argumentExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("arg");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (this.argumentExpr.getType().isEqual(BasicTypeNode.doubleType)) {
            return true;
        }
        this.reportError("The function Math::floor() expects as argument a value of type double (but is given a value of type " + this.argumentExpr.getType().getTypeName() + ").");
        return false;
    }

    @Override
    protected IR constructIR() {
        this.argumentExpr = this.argumentExpr.evaluate();
        return new FloorExpr(this.argumentExpr.checkIR(Expression.class));
    }

    @Override
    public TypeNode getType() {
        return this.argumentExpr.getType();
    }

    static {
        FloorExprNode.setName(FloorExprNode.class, "floor expr");
    }
}

