/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.numeric;

import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.ByteConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.DoubleConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.FloatConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.LongConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.ShortConstNode;
import de.unika.ipd.grgen.ast.expr.string.StringConstNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.parser.Coords;

public class IntConstNode
extends ConstNode {
    public IntConstNode(Coords coords, int n) {
        super(coords, "integer", new Integer(n));
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.intType;
    }

    @Override
    protected ConstNode doCastTo(TypeNode typeNode) {
        Integer n = (Integer)this.getValue();
        int n2 = n;
        if (typeNode.isEqual(BasicTypeNode.byteType)) {
            return new ByteConstNode(this.getCoords(), (byte)n2);
        }
        if (typeNode.isEqual(BasicTypeNode.shortType)) {
            return new ShortConstNode(this.getCoords(), (short)n2);
        }
        if (typeNode.isEqual(BasicTypeNode.longType)) {
            return new LongConstNode(this.getCoords(), n2);
        }
        if (typeNode.isEqual(BasicTypeNode.floatType)) {
            return new FloatConstNode(this.getCoords(), n2);
        }
        if (typeNode.isEqual(BasicTypeNode.doubleType)) {
            return new DoubleConstNode(this.getCoords(), n2);
        }
        if (typeNode.isEqual(BasicTypeNode.stringType)) {
            return new StringConstNode(this.getCoords(), n.toString());
        }
        throw new UnsupportedOperationException();
    }
}

