/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.numeric;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.numeric.LogExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class LogExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode leftExpr;
    private ExprNode rightExpr;

    public LogExprNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords);
        this.leftExpr = this.becomeParent(exprNode);
        this.rightExpr = this.becomeParent(exprNode2);
    }

    public LogExprNode(Coords coords, ExprNode exprNode) {
        super(coords);
        this.leftExpr = this.becomeParent(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.leftExpr);
        if (this.rightExpr != null) {
            vector.add(this.rightExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("left");
        if (this.rightExpr != null) {
            vector.add("right");
        }
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (!this.leftExpr.getType().isEqual(BasicTypeNode.doubleType)) {
            this.reportError("The function Math::log() expects as 1. argument a value of type double (but is given a value of type " + this.leftExpr.getType().getTypeName() + ").");
            return false;
        }
        if (this.rightExpr != null && !this.rightExpr.getType().isEqual(BasicTypeNode.doubleType)) {
            this.reportError("The function Math::log() expects as 2. argument a value of type double (but is given a value of type " + this.rightExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.leftExpr = this.leftExpr.evaluate();
        if (this.rightExpr != null) {
            this.rightExpr = this.rightExpr.evaluate();
            return new LogExpr(this.leftExpr.checkIR(Expression.class), this.rightExpr.checkIR(Expression.class));
        }
        return new LogExpr(this.leftExpr.checkIR(Expression.class));
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.doubleType;
    }

    static {
        LogExprNode.setName(LogExprNode.class, "log expr");
    }
}

