/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.numeric;

import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.ByteConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.DoubleConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.FloatConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.IntConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.ShortConstNode;
import de.unika.ipd.grgen.ast.expr.string.StringConstNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.parser.Coords;

public class LongConstNode
extends ConstNode {
    public LongConstNode(Coords coords, long l) {
        super(coords, "long", new Long(l));
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.longType;
    }

    @Override
    protected ConstNode doCastTo(TypeNode typeNode) {
        Long l = (Long)this.getValue();
        long l2 = l;
        if (typeNode.isEqual(BasicTypeNode.byteType)) {
            return new ByteConstNode(this.getCoords(), (byte)l2);
        }
        if (typeNode.isEqual(BasicTypeNode.shortType)) {
            return new ShortConstNode(this.getCoords(), (short)l2);
        }
        if (typeNode.isEqual(BasicTypeNode.intType)) {
            return new IntConstNode(this.getCoords(), (int)l2);
        }
        if (typeNode.isEqual(BasicTypeNode.floatType)) {
            return new FloatConstNode(this.getCoords(), l2);
        }
        if (typeNode.isEqual(BasicTypeNode.doubleType)) {
            return new DoubleConstNode(this.getCoords(), l2);
        }
        if (typeNode.isEqual(BasicTypeNode.stringType)) {
            return new StringConstNode(this.getCoords(), l.toString());
        }
        throw new UnsupportedOperationException();
    }

    public static String removeSuffix(String string) {
        if (string.endsWith("l") || string.endsWith("L")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }
}

