/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.numeric;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.numeric.MaxExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class MaxExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode leftExpr;
    private ExprNode rightExpr;

    public MaxExprNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords);
        this.leftExpr = this.becomeParent(exprNode);
        this.rightExpr = this.becomeParent(exprNode2);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.leftExpr);
        vector.add(this.rightExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("left");
        vector.add("right");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (!this.leftExpr.getType().isNumericType()) {
            this.reportError("The function Math::max() expects as 1. argument a value of type " + TypeNode.getNumericTypesAsString() + " (but is given a value of type " + this.leftExpr.getType().getTypeName() + ").");
            return false;
        }
        if (!this.rightExpr.getType().isNumericType()) {
            this.reportError("The function Math::max() expects as 2. argument a value of type " + TypeNode.getNumericTypesAsString() + " (but is given a value of type " + this.rightExpr.getType().getTypeName() + ").");
            return false;
        }
        if (!this.rightExpr.getType().isEqual(this.leftExpr.getType())) {
            this.reportError("The function Math::max() expects the 1. and 2. argument to be of the same type (but they are values of type " + this.leftExpr.getType().getTypeName() + " and " + this.rightExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.leftExpr = this.leftExpr.evaluate();
        this.rightExpr = this.rightExpr.evaluate();
        return new MaxExpr(this.leftExpr.checkIR(Expression.class), this.rightExpr.checkIR(Expression.class));
    }

    @Override
    public TypeNode getType() {
        return this.leftExpr.getType();
    }

    static {
        MaxExprNode.setName(MaxExprNode.class, "max expr");
    }
}

