/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.numeric;

import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.ByteConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.DoubleConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.FloatConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.IntConstNode;
import de.unika.ipd.grgen.ast.expr.numeric.LongConstNode;
import de.unika.ipd.grgen.ast.expr.string.StringConstNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.parser.Coords;

public class ShortConstNode
extends ConstNode {
    public ShortConstNode(Coords coords, short s) {
        super(coords, "short", new Short(s));
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.shortType;
    }

    @Override
    protected ConstNode doCastTo(TypeNode typeNode) {
        Short s = (Short)this.getValue();
        short s2 = s;
        if (typeNode.isEqual(BasicTypeNode.byteType)) {
            return new ByteConstNode(this.getCoords(), (byte)s2);
        }
        if (typeNode.isEqual(BasicTypeNode.intType)) {
            return new IntConstNode(this.getCoords(), s2);
        }
        if (typeNode.isEqual(BasicTypeNode.longType)) {
            return new LongConstNode(this.getCoords(), s2);
        }
        if (typeNode.isEqual(BasicTypeNode.floatType)) {
            return new FloatConstNode(this.getCoords(), s2);
        }
        if (typeNode.isEqual(BasicTypeNode.doubleType)) {
            return new DoubleConstNode(this.getCoords(), s2);
        }
        if (typeNode.isEqual(BasicTypeNode.stringType)) {
            return new StringConstNode(this.getCoords(), s.toString());
        }
        throw new UnsupportedOperationException();
    }

    public static String removeSuffix(String string) {
        if (string.endsWith("s") || string.endsWith("S")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }
}

