/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.numeric;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.numeric.SqrExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class SqrExprNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode expr;

    public SqrExprNode(Coords coords, ExprNode exprNode) {
        super(coords);
        this.expr = this.becomeParent(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.expr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("expr");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (this.expr.getType().isEqual(BasicTypeNode.doubleType)) {
            return true;
        }
        this.reportError("The function Math::sqr() expects as argument a value of type double (but is given a value of type " + this.expr.getType().getTypeName() + ").");
        return false;
    }

    @Override
    protected IR constructIR() {
        this.expr = this.expr.evaluate();
        return new SqrExpr(this.expr.checkIR(Expression.class));
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.doubleType;
    }

    static {
        SqrExprNode.setName(SqrExprNode.class, "sqr expr");
    }
}

