/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.procenv;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.procenv.RandomExpr;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class RandomNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode numExpr;

    public RandomNode(Coords coords, ExprNode exprNode) {
        super(coords);
        this.numExpr = exprNode;
        this.becomeParent(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        if (this.numExpr != null) {
            vector.add(this.numExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        if (this.numExpr != null) {
            vector.add("maximum random number");
        }
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (this.numExpr != null && !this.numExpr.getType().isEqual(BasicTypeNode.intType)) {
            this.reportError("The function random() expects as argument (maximumRandomNumber) a value of type int (but is given a value of type " + this.numExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        if (this.numExpr != null) {
            this.numExpr = this.numExpr.evaluate();
        }
        return new RandomExpr(this.numExpr != null ? this.numExpr.checkIR(Expression.class) : null);
    }

    @Override
    public TypeNode getType() {
        return this.numExpr != null ? BasicTypeNode.intType : BasicTypeNode.doubleType;
    }

    static {
        RandomNode.setName(RandomNode.class, "random");
    }
}

