/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.set;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.SetTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.set.SetCopyConstructor;
import de.unika.ipd.grgen.ir.type.container.SetType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class SetCopyConstructorNode
extends ExprNode {
    private SetTypeNode setType;
    private ExprNode setToCopy;
    private BaseNode lhsUnresolved;

    public SetCopyConstructorNode(Coords coords, IdentNode identNode, SetTypeNode setTypeNode, ExprNode exprNode) {
        super(coords);
        if (identNode != null) {
            this.lhsUnresolved = this.becomeParent(identNode);
        } else {
            this.setType = setTypeNode;
        }
        this.setToCopy = exprNode;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.setToCopy);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("setToCopy");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (this.setType != null) {
            return this.setType.resolve();
        }
        return true;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = true;
        if (this.lhsUnresolved != null) {
            this.reportError("A set copy constructor is not allowed in a set initialization in the model.");
            bl = false;
        } else if (this.setToCopy.getType() instanceof SetTypeNode) {
            SetTypeNode setTypeNode = (SetTypeNode)this.setToCopy.getType();
            bl &= this.checkCopyConstructorTypes(this.setType.valueType, setTypeNode.valueType, "set", false);
        } else {
            this.reportError("A set copy constructor expects a value of set type to copy (but is given " + this.setToCopy.getType().getTypeName() + ").");
            bl = false;
        }
        return bl;
    }

    @Override
    public TypeNode getType() {
        assert (this.isResolved());
        return this.setType;
    }

    @Override
    protected IR constructIR() {
        this.setToCopy = this.setToCopy.evaluate();
        return new SetCopyConstructor(this.setToCopy.checkIR(Expression.class), this.setType.checkIR(SetType.class));
    }

    public static String getKindStr() {
        return "set copy constructor";
    }

    static {
        SetCopyConstructorNode.setName(SetCopyConstructorNode.class, "set copy constructor");
    }
}

