/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.set;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ContainerSingleElementInitNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.SetTypeNode;
import de.unika.ipd.grgen.ast.util.MemberResolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.set.SetInit;
import de.unika.ipd.grgen.ir.type.container.SetType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Vector;

public class SetInitNode
extends ContainerSingleElementInitNode {
    private BaseNode lhsUnresolved;
    private DeclNode lhs;
    private SetTypeNode setType;
    private static final MemberResolver<DeclNode> lhsResolver;

    public SetInitNode(Coords coords, IdentNode identNode, SetTypeNode setTypeNode) {
        super(coords);
        if (identNode != null) {
            this.lhsUnresolved = this.becomeParent(identNode);
        } else {
            this.setType = setTypeNode;
        }
    }

    @Override
    protected boolean resolveLocal() {
        if (this.lhsUnresolved != null) {
            if (!lhsResolver.resolve(this.lhsUnresolved)) {
                return false;
            }
            this.lhs = lhsResolver.getResult(DeclNode.class);
            return lhsResolver.finish();
        }
        if (this.setType == null) {
            this.setType = this.createSetType();
        }
        return this.setType.resolve();
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = this.checkContainerItems();
        if (!this.isConstant() && this.lhs != null) {
            this.reportError("Only constant items are allowed in a set initialization in the model.");
            bl = false;
        }
        return bl;
    }

    protected SetTypeNode createSetType() {
        TypeNode typeNode = ((ExprNode)this.containerItems.getChildren().iterator().next()).getType();
        IdentNode identNode = ((DeclaredTypeNode)typeNode).getIdentNode();
        return new SetTypeNode(identNode);
    }

    @Override
    public SetTypeNode getContainerType() {
        assert (this.isResolved());
        if (this.lhs != null) {
            TypeNode typeNode = this.lhs.getDeclType();
            return (SetTypeNode)typeNode;
        }
        return this.setType;
    }

    @Override
    public boolean isInitInModel() {
        return this.setType == null;
    }

    @Override
    protected IR constructIR() {
        Vector<Expression> vector = this.constructItems();
        Entity entity = this.lhs != null ? this.lhs.getEntity() : null;
        SetType setType = this.setType != null ? this.setType.checkIR(SetType.class) : null;
        return new SetInit(vector, entity, setType, this.isConstant());
    }

    public SetInit getSetInit() {
        return this.checkIR(SetInit.class);
    }

    public static String getKindStr() {
        return "set initialization";
    }

    static {
        SetInitNode.setName(SetInitNode.class, "set init");
        lhsResolver = new MemberResolver();
    }
}

