/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.expr.string;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.expr.BuiltinFunctionInvocationBaseNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.string.StringIndexOf;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class StringIndexOfNode
extends BuiltinFunctionInvocationBaseNode {
    private ExprNode stringExpr;
    private ExprNode stringToSearchForExpr;
    private ExprNode startIndexExpr;

    public StringIndexOfNode(Coords coords, ExprNode exprNode, ExprNode exprNode2) {
        super(coords);
        this.stringExpr = this.becomeParent(exprNode);
        this.stringToSearchForExpr = this.becomeParent(exprNode2);
    }

    public StringIndexOfNode(Coords coords, ExprNode exprNode, ExprNode exprNode2, ExprNode exprNode3) {
        super(coords);
        this.stringExpr = this.becomeParent(exprNode);
        this.stringToSearchForExpr = this.becomeParent(exprNode2);
        this.startIndexExpr = this.becomeParent(exprNode3);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.stringExpr);
        vector.add(this.stringToSearchForExpr);
        if (this.startIndexExpr != null) {
            vector.add(this.startIndexExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("string");
        vector.add("stringToSearchFor");
        if (this.startIndexExpr != null) {
            vector.add("startIndex");
        }
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        if (!this.stringExpr.getType().isEqual(BasicTypeNode.stringType)) {
            this.stringExpr.reportError("The string function method indexOf can only be employed on an object of type string (but is employed on an object of type " + this.stringExpr.getType().getTypeName() + ").");
            return false;
        }
        if (!this.stringToSearchForExpr.getType().isEqual(BasicTypeNode.stringType)) {
            this.stringToSearchForExpr.reportError("The string function method indexOf expects as 1. argument (stringToSearchFor) a value of type string (but is given a value of type " + this.stringToSearchForExpr.getType().getTypeName() + ").");
            return false;
        }
        if (this.startIndexExpr != null && !this.startIndexExpr.getType().isEqual(BasicTypeNode.intType)) {
            this.startIndexExpr.reportError("The string function method indexOf expects as 2. argument (startIndex) a value of type int (but is given a value of type " + this.startIndexExpr.getType().getTypeName() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.stringExpr = this.stringExpr.evaluate();
        this.stringToSearchForExpr = this.stringToSearchForExpr.evaluate();
        if (this.startIndexExpr != null) {
            this.startIndexExpr = this.startIndexExpr.evaluate();
            return new StringIndexOf(this.stringExpr.checkIR(Expression.class), this.stringToSearchForExpr.checkIR(Expression.class), this.startIndexExpr.checkIR(Expression.class));
        }
        return new StringIndexOf(this.stringExpr.checkIR(Expression.class), this.stringToSearchForExpr.checkIR(Expression.class));
    }

    @Override
    public TypeNode getType() {
        return BasicTypeNode.intType;
    }

    static {
        StringIndexOfNode.setName(StringIndexOfNode.class, "string indexOf");
    }
}

