/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.model;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.RangeSpecNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.model.ConnAssert;
import de.unika.ipd.grgen.ir.model.type.NodeType;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ConnAssertNode
extends BaseNode {
    private NodeTypeNode src;
    private BaseNode srcUnresolved;
    private RangeSpecNode srcRange;
    private NodeTypeNode tgt;
    private BaseNode tgtUnresolved;
    private RangeSpecNode tgtRange;
    private boolean bothDirections;
    public boolean copyExtends;
    private static DeclarationTypeResolver<NodeTypeNode> nodeResolver;

    public ConnAssertNode(IdentNode identNode, RangeSpecNode rangeSpecNode, IdentNode identNode2, RangeSpecNode rangeSpecNode2, boolean bl) {
        super(identNode.getCoords());
        this.srcUnresolved = identNode;
        this.becomeParent(this.srcUnresolved);
        this.srcRange = rangeSpecNode;
        this.becomeParent(this.srcRange);
        this.tgtUnresolved = identNode2;
        this.becomeParent(this.tgtUnresolved);
        this.tgtRange = rangeSpecNode2;
        this.becomeParent(this.tgtRange);
        this.bothDirections = bl;
        this.copyExtends = false;
    }

    public ConnAssertNode(Coords coords) {
        super(coords);
        this.copyExtends = true;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        if (!this.copyExtends) {
            vector.add(this.getValidVersion(this.srcUnresolved, this.src));
            vector.add(this.srcRange);
            vector.add(this.getValidVersion(this.tgtUnresolved, this.tgt));
            vector.add(this.tgtRange);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        if (!this.copyExtends) {
            vector.add("src");
            vector.add("src range");
            vector.add("tgt");
            vector.add("tgt range");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (this.copyExtends) {
            return true;
        }
        this.src = (NodeTypeNode)nodeResolver.resolve(this.srcUnresolved, this);
        this.tgt = (NodeTypeNode)nodeResolver.resolve(this.tgtUnresolved, this);
        return this.src != null && this.tgt != null;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    protected IR constructIR() {
        assert (!this.copyExtends);
        long l = this.srcRange.getLower();
        long l2 = this.srcRange.getUpper();
        NodeType nodeType = this.src.checkIR(NodeType.class);
        long l3 = this.tgtRange.getLower();
        long l4 = this.tgtRange.getUpper();
        NodeType nodeType2 = this.tgt.checkIR(NodeType.class);
        return new ConnAssert(nodeType, l, l2, nodeType2, l3, l4, this.bothDirections);
    }

    static {
        ConnAssertNode.setName(ConnAssertNode.class, "conn assert");
        nodeResolver = new DeclarationTypeResolver<NodeTypeNode>(NodeTypeNode.class);
    }
}

