/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.model.decl;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.ScopeOwner;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.model.decl.IndexDeclNode;
import de.unika.ipd.grgen.ast.model.decl.MemberDeclNode;
import de.unika.ipd.grgen.ast.model.type.AttributeIndexTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.type.DeclaredTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.model.AttributeIndex;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import java.util.Collection;
import java.util.Vector;

public class AttributeIndexDeclNode
extends IndexDeclNode {
    public InheritanceTypeNode type;
    protected IdentNode memberUnresolved;
    public MemberDeclNode member;
    private static final AttributeIndexTypeNode attributeIndexType;
    private static DeclarationResolver<TypeDeclNode> typeResolver;
    private static final DeclarationResolver<MemberDeclNode> memberResolver;

    public AttributeIndexDeclNode(IdentNode identNode, IdentNode identNode2, IdentNode identNode3) {
        super(identNode, attributeIndexType);
        this.typeUnresolved = identNode2;
        this.becomeParent(this.typeUnresolved);
        this.memberUnresolved = identNode3;
        this.becomeParent(this.memberUnresolved);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.ident);
        vector.add(this.getValidVersion(this.typeUnresolved, this.type));
        vector.add(this.getValidVersion(this.memberUnresolved, this.member));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("ident");
        vector.add("type");
        vector.add("member");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        TypeDeclNode typeDeclNode = (TypeDeclNode)typeResolver.resolve(this.typeUnresolved, this);
        if (typeDeclNode == null) {
            return false;
        }
        DeclaredTypeNode declaredTypeNode = typeDeclNode.getDeclType();
        if (!(declaredTypeNode instanceof InheritanceTypeNode)) {
            this.typeUnresolved.reportError("The attribute index " + this.getIdentNode() + " expects a node or edge type (but is given type " + ((TypeNode)declaredTypeNode).getTypeName() + " as owner of attribute " + this.memberUnresolved + ").");
            return false;
        }
        this.type = (InheritanceTypeNode)declaredTypeNode;
        ScopeOwner scopeOwner = (ScopeOwner)((Object)declaredTypeNode);
        scopeOwner.fixupDefinition(this.memberUnresolved);
        this.member = (MemberDeclNode)memberResolver.resolve(this.memberUnresolved, this);
        return this.member != null;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public TypeNode getDeclType() {
        assert (this.isResolved());
        return attributeIndexType;
    }

    @Override
    public InheritanceTypeNode getType() {
        assert (this.isResolved());
        return this.type;
    }

    @Override
    public TypeNode getExpectedAccessType() {
        assert (this.isResolved());
        return this.member.getDeclType();
    }

    @Override
    protected IR constructIR() {
        AttributeIndex attributeIndex = new AttributeIndex(this.getIdentNode().toString(), this.getIdentNode().getIdent(), this.type.checkIR(InheritanceType.class), this.member.checkIR(Entity.class));
        return attributeIndex;
    }

    public static String getKindStr() {
        return "attribute index";
    }

    static {
        AttributeIndexDeclNode.setName(AttributeIndexDeclNode.class, "attribute index declaration");
        attributeIndexType = new AttributeIndexTypeNode();
        typeResolver = new DeclarationResolver<TypeDeclNode>(TypeDeclNode.class);
        memberResolver = new DeclarationResolver<MemberDeclNode>(MemberDeclNode.class);
    }
}

