/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.model.type;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.ConstructorDeclNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorEvaluator;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclNode;
import de.unika.ipd.grgen.ast.expr.ContainerInitNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayInitNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeInitNode;
import de.unika.ipd.grgen.ast.expr.map.MapInitNode;
import de.unika.ipd.grgen.ast.expr.set.SetInitNode;
import de.unika.ipd.grgen.ast.model.ConnAssertNode;
import de.unika.ipd.grgen.ast.model.MemberInitNode;
import de.unika.ipd.grgen.ast.model.decl.MemberDeclNode;
import de.unika.ipd.grgen.ast.model.type.ArbitraryEdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.DirectedEdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.model.type.InternalTransientObjectTypeNode;
import de.unika.ipd.grgen.ast.model.type.UndirectedEdgeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.util.CollectResolver;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ast.util.DeclarationTypeResolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.model.ConnAssert;
import de.unika.ipd.grgen.ir.model.type.EdgeType;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class EdgeTypeNode
extends InheritanceTypeNode {
    public static ArbitraryEdgeTypeNode arbitraryEdgeType;
    public static DirectedEdgeTypeNode directedEdgeType;
    public static UndirectedEdgeTypeNode undirectedEdgeType;
    private static final CollectResolver<BaseNode> bodyResolver;
    private static final CollectResolver<EdgeTypeNode> extendResolver;
    private CollectNode<EdgeTypeNode> extend;
    private CollectNode<ConnAssertNode> cas;

    public EdgeTypeNode(CollectNode<IdentNode> collectNode, CollectNode<ConnAssertNode> collectNode2, CollectNode<BaseNode> collectNode3, int n, String string) {
        this.extendUnresolved = collectNode;
        this.becomeParent(this.extendUnresolved);
        this.bodyUnresolved = collectNode3;
        this.becomeParent(this.bodyUnresolved);
        this.cas = collectNode2;
        this.becomeParent(this.cas);
        this.setModifiers(n);
        this.setExternalName(string);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.extendUnresolved, this.extend));
        vector.add(this.getValidVersion(this.bodyUnresolved, this.body));
        vector.add(this.cas);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("extends");
        vector.add("body");
        vector.add("cas");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        OperatorDeclNode.makeOp(OperatorDeclNode.Operator.COND, this, new TypeNode[]{BasicTypeNode.booleanType, this, this}, OperatorEvaluator.condEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.EQ, BasicTypeNode.booleanType, this, this, OperatorEvaluator.emptyEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.NE, BasicTypeNode.booleanType, this, this, OperatorEvaluator.emptyEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.SE, BasicTypeNode.booleanType, this, this, OperatorEvaluator.emptyEvaluator);
        this.body = bodyResolver.resolve(this.bodyUnresolved, this);
        this.extend = extendResolver.resolve(this.extendUnresolved, this);
        if (this.extend != null) {
            for (InheritanceTypeNode inheritanceTypeNode : this.extend.getChildren()) {
                inheritanceTypeNode.addDirectSubType(this);
            }
        }
        return this.body != null && this.extend != null;
    }

    @Override
    protected boolean checkLocal() {
        boolean bl = super.checkLocal();
        for (EdgeTypeNode object2 : this.extend.getChildren()) {
            if (object2.visitedDuringCheck()) continue;
            object2.check();
        }
        Vector<ConnAssertNode> vector = this.getConnectionAssertionsToCopy();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            BaseNode baseNode = (ConnAssertNode)iterator.next();
            this.cas.addChild((ConnAssertNode)baseNode);
        }
        for (BaseNode baseNode : this.body.getChildren()) {
            DeclNode declNode;
            if (baseNode instanceof ConstructorDeclNode || baseNode instanceof MemberInitNode || baseNode instanceof ContainerInitNode || baseNode instanceof FunctionDeclNode || baseNode instanceof ProcedureDeclNode || !((declNode = (DeclNode)baseNode).getDeclType() instanceof InternalTransientObjectTypeNode)) continue;
            declNode.reportError("Only transient object classes may contain attributes of transient object class types (but the attribute " + declNode.getIdentNode() + " is of transient object class type " + declNode.getDeclType().toStringWithDeclarationCoords() + " in edge class " + this.getIdentNode() + ").");
            bl &= false;
        }
        return bl;
    }

    private Vector<ConnAssertNode> getConnectionAssertionsToCopy() {
        Vector<ConnAssertNode> vector = new Vector<ConnAssertNode>();
        boolean bl = false;
        Iterator<ConnAssertNode> iterator = this.cas.getChildren().iterator();
        while (iterator.hasNext()) {
            ConnAssertNode connAssertNode = iterator.next();
            if (!connAssertNode.copyExtends) continue;
            if (bl) {
                this.reportWarning("more than one copy extends only causes double work without benefit");
            }
            for (EdgeTypeNode edgeTypeNode : this.extend.getChildren()) {
                for (ConnAssertNode connAssertNode2 : edgeTypeNode.cas.getChildren()) {
                    if (connAssertNode2.copyExtends) {
                        this.reportError("Internal error: copy extends in parent while copying connection assertions from parent.");
                        assert (false);
                    }
                    vector.add(connAssertNode2);
                }
            }
            iterator.remove();
            bl = true;
        }
        return vector;
    }

    public final EdgeType getEdgeType() {
        return this.checkIR(EdgeType.class);
    }

    public static String getKindStr() {
        return "edge class";
    }

    @Override
    protected CollectNode<? extends InheritanceTypeNode> getExtends() {
        return this.extend;
    }

    @Override
    public void doGetCompatibleToTypes(Collection<TypeNode> collection) {
        assert (this.isResolved());
        for (EdgeTypeNode edgeTypeNode : this.extend.getChildren()) {
            collection.add(edgeTypeNode);
            collection.addAll(edgeTypeNode.getCompatibleToTypes());
        }
        collection.add(BasicTypeNode.typeType);
    }

    public Collection<EdgeTypeNode> getDirectSuperTypes() {
        assert (this.isResolved());
        return this.extend.getChildren();
    }

    protected abstract void setDirectednessIR(EdgeType var1);

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        EdgeType edgeType = new EdgeType(this.getDecl().getIdentNode().getIdent(), this.getIRModifiers(), this.getExternalName());
        this.setIR(edgeType);
        this.constructIR(edgeType);
        this.setDirectednessIR(edgeType);
        for (ConnAssertNode connAssertNode : this.cas.getChildren()) {
            edgeType.addConnAssert(connAssertNode.checkIR(ConnAssert.class));
        }
        return edgeType;
    }

    static {
        EdgeTypeNode.setName(EdgeTypeNode.class, "edge type");
        bodyResolver = new CollectResolver(new DeclarationResolver(MemberDeclNode.class, MemberInitNode.class, ConstructorDeclNode.class, MapInitNode.class, SetInitNode.class, ArrayInitNode.class, DequeInitNode.class, FunctionDeclNode.class, ProcedureDeclNode.class));
        extendResolver = new CollectResolver<EdgeTypeNode>(new DeclarationTypeResolver<EdgeTypeNode>(EdgeTypeNode.class));
    }
}

