/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.model.type;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.ConstructorParamNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.MemberAccessor;
import de.unika.ipd.grgen.ast.decl.ConstructorDeclNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionOrOperatorDeclBaseNode;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclBaseNode;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayInitNode;
import de.unika.ipd.grgen.ast.expr.deque.DequeInitNode;
import de.unika.ipd.grgen.ast.expr.map.MapInitNode;
import de.unika.ipd.grgen.ast.expr.set.SetInitNode;
import de.unika.ipd.grgen.ast.model.MemberInitNode;
import de.unika.ipd.grgen.ast.model.decl.AbstractMemberDeclNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.CompoundTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.FunctionMethod;
import de.unika.ipd.grgen.ir.executable.ProcedureMethod;
import de.unika.ipd.grgen.ir.expr.array.ArrayInit;
import de.unika.ipd.grgen.ir.expr.deque.DequeInit;
import de.unika.ipd.grgen.ir.expr.map.MapInit;
import de.unika.ipd.grgen.ir.expr.set.SetInit;
import de.unika.ipd.grgen.ir.model.MemberInit;
import de.unika.ipd.grgen.ir.model.type.InheritanceType;
import de.unika.ipd.grgen.parser.Symbol;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Vector;

public abstract class InheritanceTypeNode
extends CompoundTypeNode
implements MemberAccessor {
    public static final int MOD_CONST = 1;
    public static final int MOD_ABSTRACT = 2;
    protected CollectNode<IdentNode> extendUnresolved;
    protected CollectNode<BaseNode> bodyUnresolved;
    protected CollectNode<BaseNode> body;
    private int modifiers = 0;
    private String externalName = null;
    private Map<String, DeclNode> allMembers = null;
    private Collection<InheritanceTypeNode> allSuperTypes = null;
    private Collection<InheritanceTypeNode> directSubTypes = new LinkedHashSet<InheritanceTypeNode>();
    private Collection<InheritanceTypeNode> allSubTypes = null;

    public void addDirectSubType(InheritanceTypeNode inheritanceTypeNode) {
        this.directSubTypes.add(inheritanceTypeNode);
    }

    protected Collection<InheritanceTypeNode> getAllSubTypes() {
        assert (this.isResolved());
        if (this.allSubTypes == null) {
            this.allSubTypes = new HashSet<InheritanceTypeNode>();
            for (InheritanceTypeNode inheritanceTypeNode : this.directSubTypes) {
                this.allSubTypes.addAll(inheritanceTypeNode.getAllSubTypes());
                this.allSubTypes.add(inheritanceTypeNode);
            }
        }
        return this.allSubTypes;
    }

    public boolean isA(InheritanceTypeNode inheritanceTypeNode) {
        assert (inheritanceTypeNode != null);
        return this == inheritanceTypeNode || this.getAllSuperTypes().contains(inheritanceTypeNode);
    }

    protected Collection<InheritanceTypeNode> getAllSuperTypes() {
        if (this.allSuperTypes == null) {
            this.allSuperTypes = new HashSet<InheritanceTypeNode>();
            for (InheritanceTypeNode inheritanceTypeNode : this.getDirectSuperTypes()) {
                this.allSuperTypes.addAll(inheritanceTypeNode.getAllSuperTypes());
                this.allSuperTypes.add(inheritanceTypeNode);
            }
        }
        return this.allSuperTypes;
    }

    public static boolean hasCommonSubtype(InheritanceTypeNode inheritanceTypeNode, InheritanceTypeNode inheritanceTypeNode2) {
        if (inheritanceTypeNode.isA(inheritanceTypeNode2)) {
            return true;
        }
        if (inheritanceTypeNode2.isA(inheritanceTypeNode)) {
            return true;
        }
        Collection<InheritanceTypeNode> collection = inheritanceTypeNode.getAllSubTypes();
        Collection<InheritanceTypeNode> collection2 = inheritanceTypeNode2.getAllSubTypes();
        for (TypeNode typeNode : collection2) {
            if (!collection.contains(typeNode)) continue;
            return true;
        }
        return false;
    }

    public CollectNode<BaseNode> getBody() {
        return this.body;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean checkLocal() {
        void var3_8;
        BaseNode baseNode3;
        boolean bl = super.checkLocal();
        this.getAllSuperTypes();
        for (DeclNode object : this.getAllMembers().values()) {
            if (!(object instanceof AbstractMemberDeclNode) || this.isAbstract()) continue;
            this.getIdentNode().reportError("The " + this.getKind() + " " + this.getTypeName() + " must be declared abstract, because member " + object + " is abstract.");
            bl = false;
        }
        for (BaseNode baseNode2 : this.body.getChildren()) {
            if (!(baseNode2 instanceof DeclNode) || baseNode2 instanceof ConstructorDeclNode || !((DeclNode)(baseNode3 = (DeclNode)baseNode2)).getIdentNode().toString().equals(this.getIdentNode().toString())) continue;
            this.getIdentNode().reportError("The member " + ((DeclNode)baseNode3).getIdentNode() + " must be named differently than its containing " + this.getKind() + " " + this.getTypeName() + ".");
        }
        Vector vector = new Vector();
        for (BaseNode baseNode3 : this.body.getChildren()) {
            if (!(baseNode3 instanceof ConstructorDeclNode)) continue;
            vector.add((ConstructorDeclNode)baseNode3);
        }
        boolean bl2 = false;
        while (var3_8 < vector.size()) {
            baseNode3 = (ConstructorDeclNode)vector.get((int)var3_8);
            Vector<ConstructorParamNode> vector2 = ((ConstructorDeclNode)baseNode3).getParameters().getChildrenAsVector();
            int n = vector2.size();
            for (void var7_12 = var3_8 + true; var7_12 < vector.size(); ++var7_12) {
                int n2;
                ConstructorDeclNode constructorDeclNode = (ConstructorDeclNode)vector.get((int)var7_12);
                Vector<ConstructorParamNode> vector3 = constructorDeclNode.getParameters().getChildrenAsVector();
                int n3 = vector3.size();
                boolean bl3 = false;
                for (n2 = 0; n2 < n && n2 < n3; ++n2) {
                    ConstructorParamNode constructorParamNode = vector2.get(n2);
                    ConstructorParamNode constructorParamNode2 = vector3.get(n2);
                    if (constructorParamNode.rhs != null && constructorParamNode2.rhs != null) {
                        bl3 = true;
                        break;
                    }
                    if (constructorParamNode.lhs.getDeclType() != constructorParamNode2.lhs.getDeclType()) break;
                }
                if (n2 == n && n2 == n3 || n2 == n && vector3.get((int)n2).rhs != null || n2 == n3 && vector2.get((int)n2).rhs != null) {
                    bl3 = true;
                }
                if (!bl3) continue;
                baseNode3.reportError("Constructor is ambiguous (other constructor at " + constructorDeclNode.getCoords() + ").");
                bl = false;
            }
            ++var3_8;
        }
        return bl &= this.checkMembers();
    }

    @Override
    public InheritanceType getType() {
        return this.checkIR(InheritanceType.class);
    }

    protected abstract CollectNode<? extends InheritanceTypeNode> getExtends();

    @Override
    public boolean fixupDefinition(IdentNode identNode) {
        assert (this.isResolved());
        if (InheritanceTypeNode.fixupDefinition(identNode, this.getScope(), false)) {
            return true;
        }
        Symbol.Definition definition = null;
        for (InheritanceTypeNode inheritanceTypeNode : this.getExtends().getChildren()) {
            if (!inheritanceTypeNode.fixupDefinition(identNode)) continue;
            Symbol.Definition definition2 = identNode.getSymDef();
            if (definition == null) {
                definition = definition2;
                continue;
            }
            if (definition == definition2) continue;
            this.getIdentNode().reportError("Identifier " + identNode + " is ambiguous [one declaration at " + definition2.getCoords() + ", another declaration at " + definition.getCoords() + "]. There must be one unique declaration of a member, in a common parent; or different names must be used for different members. A method that comes in from more than one parent must be implemented locally, overriding the parental versions.");
        }
        return definition != null;
    }

    protected void setModifiers(int n) {
        this.modifiers = n;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isConst() {
        return (this.modifiers & 1) != 0;
    }

    protected final int getIRModifiers() {
        return (this.isAbstract() ? 1 : 0) | (this.isConst() ? 2 : 0);
    }

    protected void setExternalName(String string) {
        this.externalName = string;
    }

    protected final String getExternalName() {
        return this.externalName;
    }

    public abstract Collection<? extends InheritanceTypeNode> getDirectSuperTypes();

    @Override
    public DeclNode tryGetMember(String string) {
        return this.getAllMembers().get(string);
    }

    protected void getMembers(Map<String, DeclNode> map) {
        assert (this.isResolved());
        for (BaseNode baseNode : this.body.getChildren()) {
            if (!(baseNode instanceof DeclNode)) continue;
            DeclNode declNode = (DeclNode)baseNode;
            map.put(declNode.getIdentNode().toString(), declNode);
        }
    }

    protected boolean checkMembers() {
        boolean bl = true;
        assert (this.isResolved());
        LinkedHashMap<String, DeclNode> linkedHashMap = new LinkedHashMap<String, DeclNode>();
        for (InheritanceTypeNode baseNode : this.getDirectSuperTypes()) {
            linkedHashMap.putAll(baseNode.getAllMembers());
        }
        for (BaseNode baseNode : this.body.getChildren()) {
            DeclNode declNode;
            DeclNode declNode2;
            if (baseNode instanceof ConstructorDeclNode) continue;
            if (baseNode instanceof FunctionDeclNode) {
                declNode2 = (FunctionDeclNode)baseNode;
                bl &= this.checkFunctionOverride((FunctionDeclNode)declNode2);
                continue;
            }
            if (baseNode instanceof ProcedureDeclNode) {
                declNode2 = (ProcedureDeclNode)baseNode;
                bl &= this.checkProcedureOverride((ProcedureDeclNode)declNode2);
                continue;
            }
            if (!(baseNode instanceof DeclNode) || (declNode = (DeclNode)linkedHashMap.get((declNode2 = (DeclNode)baseNode).getIdentNode().toString())) == null || declNode instanceof AbstractMemberDeclNode) continue;
            declNode2.reportError("The member " + declNode2.getIdentNode() + " of " + this.getKind() + " " + this.getIdentNode() + " is already declared at " + this.getContainingType(declNode).toStringWithDeclarationCoords() + ".");
            bl = false;
        }
        return bl;
    }

    private TypeNode getContainingType(DeclNode declNode) {
        BaseNode baseNode = declNode.getParents().iterator().next();
        BaseNode baseNode2 = baseNode.getParents().iterator().next();
        return (TypeNode)baseNode2;
    }

    private boolean checkFunctionOverride(FunctionDeclNode functionDeclNode) {
        boolean bl = true;
        if (!functionDeclNode.isChecked()) {
            return bl;
        }
        for (InheritanceTypeNode inheritanceTypeNode : this.getAllSuperTypes()) {
            for (BaseNode baseNode : inheritanceTypeNode.getBody().getChildren()) {
                FunctionDeclNode functionDeclNode2;
                if (!(baseNode instanceof FunctionDeclNode) || !(functionDeclNode2 = (FunctionDeclNode)baseNode).isChecked() || !functionDeclNode.ident.toString().equals(functionDeclNode2.ident.toString())) continue;
                bl &= InheritanceTypeNode.checkSignatureAdhered(functionDeclNode2, functionDeclNode);
            }
        }
        return bl;
    }

    private boolean checkProcedureOverride(ProcedureDeclNode procedureDeclNode) {
        boolean bl = true;
        if (!procedureDeclNode.isChecked()) {
            return bl;
        }
        for (InheritanceTypeNode inheritanceTypeNode : this.getAllSuperTypes()) {
            for (BaseNode baseNode : inheritanceTypeNode.getBody().getChildren()) {
                ProcedureDeclNode procedureDeclNode2;
                if (!(baseNode instanceof ProcedureDeclNode) || !(procedureDeclNode2 = (ProcedureDeclNode)baseNode).isChecked() || !procedureDeclNode.ident.toString().equals(procedureDeclNode2.ident.toString())) continue;
                bl &= InheritanceTypeNode.checkSignatureAdhered(procedureDeclNode2, procedureDeclNode);
            }
        }
        return bl;
    }

    public Map<String, DeclNode> getAllMembers() {
        if (this.allMembers == null) {
            this.allMembers = new LinkedHashMap<String, DeclNode>();
            for (InheritanceTypeNode inheritanceTypeNode : this.getDirectSuperTypes()) {
                this.allMembers.putAll(inheritanceTypeNode.getAllMembers());
            }
            this.getMembers(this.allMembers);
        }
        return this.allMembers;
    }

    public boolean checkStatementsInMethods() {
        boolean bl = true;
        for (BaseNode baseNode : this.body.getChildren()) {
            DeclNode declNode;
            if (baseNode instanceof FunctionDeclNode) {
                declNode = (FunctionDeclNode)baseNode;
                bl &= EvalStatementNode.checkStatements(true, declNode, null, declNode.evalStatements, true);
                continue;
            }
            if (!(baseNode instanceof ProcedureDeclNode)) continue;
            declNode = (ProcedureDeclNode)baseNode;
            bl &= EvalStatementNode.checkStatements(false, declNode, null, ((ProcedureDeclNode)declNode).evalStatements, true);
        }
        return bl;
    }

    protected static boolean checkSignatureAdhered(FunctionOrOperatorDeclBaseNode functionOrOperatorDeclBaseNode, FunctionOrOperatorDeclBaseNode functionOrOperatorDeclBaseNode2) {
        int n;
        String string = functionOrOperatorDeclBaseNode.ident.toString();
        Vector<TypeNode> vector = functionOrOperatorDeclBaseNode.getParameterTypes();
        Vector<TypeNode> vector2 = functionOrOperatorDeclBaseNode2.getParameterTypes();
        int n2 = vector.size();
        if (n2 != (n = vector2.size())) {
            functionOrOperatorDeclBaseNode2.reportError("The function method " + string + " is declared with " + n2 + " parameters in a parent class" + functionOrOperatorDeclBaseNode.getAtCoords() + ", but is overriden here with " + n + " parameters.");
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < n2; ++i) {
            TypeNode typeNode;
            TypeNode typeNode2 = vector.get(i);
            if (typeNode2.isEqual(typeNode = vector2.get(i))) continue;
            bl = false;
            functionOrOperatorDeclBaseNode2.reportError("The function method " + string + " is declared with a " + (i + 1) + ". parameter of type " + typeNode2.getTypeName() + " in a parent class" + functionOrOperatorDeclBaseNode.getAtCoords() + ", but is overriden here with a " + (i + 1) + ". parameter of type " + typeNode.getTypeName() + ".");
        }
        if (!functionOrOperatorDeclBaseNode.getResultType().isEqual(functionOrOperatorDeclBaseNode2.getResultType())) {
            functionOrOperatorDeclBaseNode2.reportError("The function method " + string + " is declared with a return parameter of type " + functionOrOperatorDeclBaseNode.getResultType().getTypeName() + " in a parent class" + functionOrOperatorDeclBaseNode.getAtCoords() + ", but is overriden here with a return parameter of type " + functionOrOperatorDeclBaseNode2.getResultType().getTypeName() + ".");
        }
        return bl;
    }

    protected static boolean checkSignatureAdhered(ProcedureDeclBaseNode procedureDeclBaseNode, ProcedureDeclBaseNode procedureDeclBaseNode2) {
        int n;
        Object object;
        int n2;
        String string = procedureDeclBaseNode.ident.toString();
        Vector<TypeNode> vector = procedureDeclBaseNode.getParameterTypes();
        Vector<TypeNode> vector2 = procedureDeclBaseNode2.getParameterTypes();
        int n3 = vector.size();
        if (n3 != (n2 = vector2.size())) {
            procedureDeclBaseNode2.reportError("The procedure method " + string + " is declared with " + n3 + " parameters in a parent class" + procedureDeclBaseNode.getAtCoords() + ", but is overriden here with " + n2 + " parameters.");
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            TypeNode typeNode;
            object = vector.get(i);
            if (((TypeNode)object).isEqual(typeNode = vector2.get(i))) continue;
            bl = false;
            procedureDeclBaseNode2.reportError("The procedure method " + string + " is declared with a " + (i + 1) + ". parameter of type " + ((TypeNode)object).getTypeName() + " in a parent class" + procedureDeclBaseNode.getAtCoords() + ", but is overriden here with a " + (i + 1) + ". parameter of type " + typeNode.getTypeName() + ".");
        }
        Vector<TypeNode> vector3 = procedureDeclBaseNode.getResultTypes();
        object = procedureDeclBaseNode2.getResultTypes();
        int n4 = vector3.size();
        if (n4 != (n = ((Vector)object).size())) {
            procedureDeclBaseNode2.reportError("The procedure method " + string + " is declared with " + n4 + " return parameters in a parent class" + procedureDeclBaseNode.getAtCoords() + ", but is overriden here with " + n + " return parameters.");
            return false;
        }
        for (int i = 0; i < n4; ++i) {
            TypeNode typeNode;
            TypeNode typeNode2 = vector3.get(i);
            if (typeNode2.isEqual(typeNode = (TypeNode)((Vector)object).get(i))) continue;
            bl = false;
            procedureDeclBaseNode2.reportError("The procedure method " + string + " is declared with a " + (i + 1) + ". return parameter of type " + typeNode2.getTypeName() + " in a parent class" + procedureDeclBaseNode.getAtCoords() + ", but is overriden here with a " + (i + 1) + ". return parameter of type " + typeNode.getTypeName() + ".");
        }
        return bl;
    }

    protected void constructIR(InheritanceType inheritanceType) {
        for (BaseNode baseNode : this.body.getChildren()) {
            InheritanceTypeNode.constructAndAddIRChild(inheritanceType, baseNode);
        }
        for (InheritanceTypeNode inheritanceTypeNode : this.getExtends().getChildren()) {
            inheritanceType.addDirectSuperType(inheritanceTypeNode.getType());
        }
    }

    private static void constructAndAddIRChild(InheritanceType inheritanceType, BaseNode baseNode) {
        if (baseNode instanceof ConstructorDeclNode) {
            ConstructorDeclNode constructorDeclNode = (ConstructorDeclNode)baseNode;
            inheritanceType.addConstructor(constructorDeclNode.getConstructor());
        } else if (baseNode instanceof DeclNode) {
            DeclNode declNode = (DeclNode)baseNode;
            if (baseNode instanceof FunctionDeclNode) {
                inheritanceType.addFunctionMethod(baseNode.checkIR(FunctionMethod.class));
            } else if (baseNode instanceof ProcedureDeclNode) {
                inheritanceType.addProcedureMethod(baseNode.checkIR(ProcedureMethod.class));
            } else {
                inheritanceType.addMember(declNode.getEntity());
            }
        } else if (baseNode instanceof MemberInitNode) {
            MemberInitNode memberInitNode = (MemberInitNode)baseNode;
            IR iR = memberInitNode.getIR();
            if (iR instanceof MapInit) {
                inheritanceType.addMapInit(memberInitNode.checkIR(MapInit.class));
            } else if (iR instanceof SetInit) {
                inheritanceType.addSetInit(memberInitNode.checkIR(SetInit.class));
            } else if (iR instanceof ArrayInit) {
                inheritanceType.addArrayInit(memberInitNode.checkIR(ArrayInit.class));
            } else if (iR instanceof DequeInit) {
                inheritanceType.addDequeInit(memberInitNode.checkIR(DequeInit.class));
            } else {
                inheritanceType.addMemberInit(memberInitNode.checkIR(MemberInit.class));
            }
        } else if (baseNode instanceof MapInitNode) {
            MapInitNode mapInitNode = (MapInitNode)baseNode;
            inheritanceType.addMapInit(mapInitNode.getMapInit());
        } else if (baseNode instanceof SetInitNode) {
            SetInitNode setInitNode = (SetInitNode)baseNode;
            inheritanceType.addSetInit(setInitNode.getSetInit());
        } else if (baseNode instanceof ArrayInitNode) {
            ArrayInitNode arrayInitNode = (ArrayInitNode)baseNode;
            inheritanceType.addArrayInit(arrayInitNode.getArrayInit());
        } else if (baseNode instanceof DequeInitNode) {
            DequeInitNode dequeInitNode = (DequeInitNode)baseNode;
            inheritanceType.addDequeInit(dequeInitNode.getDequeInit());
        }
    }

    @Override
    public String toString() {
        return this.getIdentNode().toString() + " (" + super.toString() + ")";
    }
}

