/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.model.type.DirectedEdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.model.type.UndirectedEdgeTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationPairResolver;
import de.unika.ipd.grgen.ast.util.Pair;
import de.unika.ipd.grgen.ast.util.TypeChecker;
import de.unika.ipd.grgen.parser.Coords;
import java.awt.Color;
import java.util.Collection;
import java.util.Vector;

public class HomNode
extends BaseNode {
    private Vector<NodeDeclNode> childrenNode = new Vector();
    private Vector<EdgeDeclNode> childrenEdge = new Vector();
    private Vector<BaseNode> childrenUnresolved = new Vector();
    private static final DeclarationPairResolver<NodeDeclNode, EdgeDeclNode> declResolver;
    private static final TypeChecker nodeTypeChecker;
    private static final TypeChecker edgeTypeChecker;

    public HomNode(Coords coords) {
        super(coords);
    }

    public void addChild(BaseNode baseNode) {
        assert (!this.isResolved());
        this.becomeParent(baseNode);
        this.childrenUnresolved.add(baseNode);
    }

    public Collection<BaseNode> getChildren() {
        return this.getValidVersionVector(this.childrenUnresolved, this.childrenNode, this.childrenEdge);
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        return vector;
    }

    public Vector<NodeDeclNode> getHomNodes() {
        return this.childrenNode;
    }

    public Vector<EdgeDeclNode> getHomEdges() {
        return this.childrenEdge;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        for (int i = 0; i < this.childrenUnresolved.size(); ++i) {
            Object object = declResolver.resolve(this.childrenUnresolved.get(i), this);
            boolean bl2 = bl = object != null && bl;
            if (object == null) continue;
            if (((Pair)object).fst != null) {
                this.childrenNode.add((NodeDeclNode)((Pair)object).fst);
            }
            if (((Pair)object).snd == null) continue;
            this.childrenEdge.add((EdgeDeclNode)((Pair)object).snd);
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        if (this.childrenNode.isEmpty() && this.childrenEdge.isEmpty()) {
            this.reportError("The hom statement is empty.");
            return false;
        }
        if (!this.childrenNode.isEmpty() && !this.childrenEdge.isEmpty()) {
            this.reportError("The hom statement may only contain nodes or edges at a time (this is violated by node " + this.childrenNode.get(0) + " and edge " + this.childrenEdge.get(0) + ").");
            return false;
        }
        boolean bl = true;
        for (NodeDeclNode constraintDeclNode : this.childrenNode) {
            bl = nodeTypeChecker.check(constraintDeclNode, error) && bl;
        }
        for (EdgeDeclNode edgeDeclNode : this.childrenEdge) {
            bl = edgeTypeChecker.check(edgeDeclNode, error) && bl;
        }
        this.warnEdgeTypes();
        return bl;
    }

    private void warnEdgeTypes() {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.childrenEdge.size(); ++i) {
            EdgeTypeNode edgeTypeNode = this.childrenEdge.get(i).getDeclType();
            if (edgeTypeNode instanceof DirectedEdgeTypeNode) {
                bl = true;
            }
            if (!(edgeTypeNode instanceof UndirectedEdgeTypeNode)) continue;
            bl2 = true;
        }
        if (bl && bl2) {
            this.reportWarning("The hom statement may only contain directed or undirected edges at a time.");
        }
    }

    @Override
    public Color getNodeColor() {
        return Color.PINK;
    }

    static {
        HomNode.setName(HomNode.class, "homomorph");
        declResolver = new DeclarationPairResolver<NodeDeclNode, EdgeDeclNode>(NodeDeclNode.class, EdgeDeclNode.class);
        nodeTypeChecker = new TypeChecker(NodeTypeNode.class);
        edgeTypeChecker = new TypeChecker(EdgeTypeNode.class);
    }
}

