/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.TypeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.ExactNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.PatternGraphBase;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ImplicitNegComputer {
    PatternGraphLhsNode patternGraph;
    private Set<NodeDeclNode> nodesRequiringNeg = new LinkedHashSet<NodeDeclNode>();
    private Map<Set<NodeDeclNode>, Set<ConnectionNode>> homNodesToEdges = new LinkedHashMap<Set<NodeDeclNode>, Set<ConnectionNode>>();
    int implicitNegCounter = 0;

    public ImplicitNegComputer(PatternGraphLhsNode patternGraphLhsNode) {
        Object object;
        this.patternGraph = patternGraphLhsNode;
        if (patternGraphLhsNode.isExact()) {
            this.nodesRequireNeg(patternGraphLhsNode.getNodes());
            if (patternGraphLhsNode.isDangling() && !patternGraphLhsNode.isIdentification()) {
                patternGraphLhsNode.reportWarning("The keyword \"dangling\" is redundant for exact patterns");
            }
            for (ExactNode exactNode : patternGraphLhsNode.exacts.getChildren()) {
                exactNode.reportWarning("Exact statement occurs in exact pattern");
            }
            return;
        }
        if (patternGraphLhsNode.isDangling()) {
            object = patternGraphLhsNode.getRule().getDeletedElements();
            this.nodesRequireNeg(ImplicitNegComputer.getDpoPatternNodes((Set<ConstraintDeclNode>)object));
            for (ExactNode exactNode : patternGraphLhsNode.exacts.getChildren()) {
                for (NodeDeclNode nodeDeclNode : exactNode.getExactNodes()) {
                    if (!object.contains(nodeDeclNode)) continue;
                    exactNode.reportWarning("Exact statement for " + nodeDeclNode.getKind() + " " + nodeDeclNode.getIdentNode().getSymbol().getText() + " is redundant, since the pattern is declared \"dangling\" or \"dpo\"");
                }
            }
        }
        object = new LinkedHashMap();
        for (int i = 0; i < patternGraphLhsNode.exacts.getChildren().size(); ++i) {
            ExactNode exactNode;
            exactNode = patternGraphLhsNode.exacts.get(i);
            for (NodeDeclNode nodeDeclNode : exactNode.getExactNodes()) {
                if (object.containsKey(nodeDeclNode)) {
                    exactNode.reportWarning(nodeDeclNode.getKind() + " " + nodeDeclNode.getIdentNode().getSymbol().getText() + " already occurs in exact statement at " + patternGraphLhsNode.exacts.get((Integer)object.get(nodeDeclNode)).getCoords());
                    continue;
                }
                object.put(nodeDeclNode, i);
            }
        }
        this.nodesRequireNeg(object.keySet());
    }

    private void nodesRequireNeg(Set<NodeDeclNode> set) {
        for (NodeDeclNode nodeDeclNode : set) {
            if (nodeDeclNode.isDummy()) continue;
            this.nodesRequiringNeg.add(nodeDeclNode);
            Set<NodeDeclNode> set2 = this.patternGraph.getHomomorphic(nodeDeclNode);
            if (this.homNodesToEdges.containsKey(set2)) continue;
            HashSet hashSet = new HashSet();
            this.homNodesToEdges.put(set2, hashSet);
        }
    }

    private static Set<NodeDeclNode> getDpoPatternNodes(Set<ConstraintDeclNode> set) {
        LinkedHashSet<NodeDeclNode> linkedHashSet = new LinkedHashSet<NodeDeclNode>();
        for (DeclNode declNode : set) {
            NodeDeclNode nodeDeclNode;
            if (!(declNode instanceof NodeDeclNode) || (nodeDeclNode = (NodeDeclNode)declNode).isDummy()) continue;
            linkedHashSet.add(nodeDeclNode);
        }
        return linkedHashSet;
    }

    public LinkedList<PatternGraphLhs> getImplicitNegGraphs() {
        Set<ConnectionNode> set;
        Object object;
        Set<ConnectionNode> set2;
        BaseNode baseNode2;
        assert (this.patternGraph.isResolved());
        LinkedList<PatternGraphLhs> linkedList = new LinkedList<PatternGraphLhs>();
        for (BaseNode baseNode2 : this.patternGraph.connections.getChildren()) {
            if (!(baseNode2 instanceof ConnectionNode)) continue;
            ConnectionNode connectionNode = (ConnectionNode)baseNode2;
            NodeDeclNode nodeDeclNode = connectionNode.getSrc();
            if (this.nodesRequiringNeg.contains(nodeDeclNode)) {
                set2 = this.patternGraph.getHomomorphic(nodeDeclNode);
                object = this.homNodesToEdges.get(set2);
                object.add((ConnectionNode)connectionNode);
                this.homNodesToEdges.put((Set<NodeDeclNode>)set2, (Set<ConnectionNode>)object);
            }
            if (!this.nodesRequiringNeg.contains(set2 = connectionNode.getTgt())) continue;
            object = this.patternGraph.getHomomorphic((NodeDeclNode)((Object)set2));
            set = this.homNodesToEdges.get(object);
            set.add(connectionNode);
            this.homNodesToEdges.put((Set<NodeDeclNode>)object, set);
        }
        TypeDeclNode typeDeclNode = this.patternGraph.getArbitraryEdgeRootTypeDecl();
        baseNode2 = this.patternGraph.getNodeRootTypeDecl();
        for (NodeDeclNode nodeDeclNode : this.nodesRequiringNeg) {
            BaseNode baseNode32;
            set2 = this.homNodesToEdges.get(this.patternGraph.getHomomorphic(nodeDeclNode));
            object = new PatternGraphLhs("implneg_" + this.implicitNegCounter, 0);
            ++this.implicitNegCounter;
            ((PatternGraphBase)object).setDirectlyNestingLHSGraph((PatternGraphLhs)object);
            set = new LinkedHashSet<ConnectionNode>();
            LinkedHashSet<NodeDeclNode> linkedHashSet = new LinkedHashSet<NodeDeclNode>();
            for (BaseNode baseNode32 : set2) {
                baseNode32.addToGraph((PatternGraphBase)object);
                set.add((ConnectionNode)((Object)baseNode32.getEdge()));
                linkedHashSet.add(baseNode32.getSrc());
                linkedHashSet.add(baseNode32.getTgt());
            }
            this.addInheritedHomSet((PatternGraphLhs)object, set, linkedHashSet);
            EdgeDeclNode edgeDeclNode = this.patternGraph.getAnonymousEdgeDecl(typeDeclNode, this.patternGraph.context);
            baseNode32 = this.patternGraph.getAnonymousDummyNode((TypeDeclNode)baseNode2, this.patternGraph.context);
            ConnectionNode connectionNode = new ConnectionNode(nodeDeclNode, edgeDeclNode, (NodeDeclNode)baseNode32, ConnectionNode.ConnectionKind.ARBITRARY, this.patternGraph);
            connectionNode.addToGraph((PatternGraphBase)object);
            linkedList.add((PatternGraphLhs)object);
        }
        return linkedList;
    }

    private void addInheritedHomSet(PatternGraphLhs patternGraphLhs, Set<EdgeDeclNode> set, Set<NodeDeclNode> set2) {
        Set<ConstraintDeclNode> set3;
        LinkedHashSet<Node> linkedHashSet;
        for (NodeDeclNode constraintDeclNode : set2) {
            linkedHashSet = new LinkedHashSet<Node>();
            set3 = this.patternGraph.getHomomorphic(constraintDeclNode);
            for (ConstraintDeclNode constraintDeclNode2 : set3) {
                if (!set2.contains(constraintDeclNode2)) continue;
                linkedHashSet.add(constraintDeclNode2.checkIR(Node.class));
            }
            if (linkedHashSet.size() <= 1) continue;
            patternGraphLhs.addHomomorphicNodes(linkedHashSet);
        }
        for (EdgeDeclNode edgeDeclNode : set) {
            linkedHashSet = new LinkedHashSet();
            set3 = this.patternGraph.getHomomorphic(edgeDeclNode);
            for (ConstraintDeclNode constraintDeclNode2 : set3) {
                if (!set.contains(constraintDeclNode2)) continue;
                linkedHashSet.add((Node)((Object)constraintDeclNode2.checkIR(Edge.class)));
            }
            if (linkedHashSet.size() <= 1) continue;
            patternGraphLhs.addHomomorphicEdges(linkedHashSet);
        }
    }
}

