/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.decl.MemberDeclNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.StringTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.NameOrAttributeInitialization;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

public class NameOrAttributeInitializationNode
extends BaseNode {
    public ConstraintDeclNode owner;
    public GraphEntity ownerIR;
    public IdentNode attributeUnresolved;
    public MemberDeclNode attribute;
    public ExprNode initialization;
    private static final DeclarationResolver<MemberDeclNode> memberResolver = new DeclarationResolver<MemberDeclNode>(MemberDeclNode.class);

    public NameOrAttributeInitializationNode(ConstraintDeclNode constraintDeclNode, IdentNode identNode, ExprNode exprNode) {
        this.owner = constraintDeclNode;
        this.attributeUnresolved = identNode;
        this.initialization = exprNode;
    }

    public NameOrAttributeInitializationNode(ConstraintDeclNode constraintDeclNode, ExprNode exprNode) {
        this.owner = constraintDeclNode;
        this.initialization = exprNode;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        if (this.attributeUnresolved != null) {
            vector.add(this.getValidVersion(this.attributeUnresolved, this.attribute));
        }
        vector.add(this.initialization);
        return vector;
    }

    @Override
    protected Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        if (this.attributeUnresolved != null) {
            vector.add("attribute");
        }
        vector.add("initialization");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        if (this.attributeUnresolved != null) {
            this.owner.getDeclType().fixupDefinition(this.attributeUnresolved);
            this.attribute = (MemberDeclNode)memberResolver.resolve(this.attributeUnresolved, this);
            return this.attribute != null;
        }
        return true;
    }

    @Override
    protected boolean checkLocal() {
        if (this.attributeUnresolved == null) {
            BasicTypeNode basicTypeNode = StringTypeNode.stringType;
            TypeNode typeNode = this.initialization.getType();
            if (typeNode.isEqual(basicTypeNode)) {
                return true;
            }
            this.initialization = this.becomeParent(this.initialization.adjustType(basicTypeNode, this.owner.getCoords()));
            if (this.initialization == ConstNode.getInvalid()) {
                this.owner.reportError("The name of an element must be initialized with a value of type string (but it is initialized with a value of type " + typeNode.getTypeName() + ").");
                return false;
            }
            return true;
        }
        if (this.attribute.isConst()) {
            this.owner.reportError("An assignment to a const member is not allowed (but " + this.attribute.getIdentNode() + " is const).");
            return false;
        }
        if (this.owner.getDeclType().isConst()) {
            this.owner.reportError("An assignment to a const type object is not allowed (but " + this.owner.getDeclType().getTypeName() + " is const).");
            return false;
        }
        TypeNode typeNode = this.attribute.getDeclType();
        TypeNode typeNode2 = this.initialization.getType();
        if (typeNode2.isEqual(typeNode)) {
            return true;
        }
        this.initialization = this.becomeParent(this.initialization.adjustType(typeNode, this.owner.getCoords()));
        if (this.initialization == ConstNode.getInvalid()) {
            return false;
        }
        if (typeNode instanceof NodeTypeNode && typeNode2 instanceof NodeTypeNode || typeNode instanceof EdgeTypeNode && typeNode2 instanceof EdgeTypeNode) {
            HashSet<TypeNode> hashSet = new HashSet<TypeNode>();
            typeNode2.doGetCompatibleToTypes(hashSet);
            if (!hashSet.contains(typeNode)) {
                this.owner.reportError("Cannot initialize an attribute of type " + typeNode.toStringWithDeclarationCoords() + " with a value of type " + typeNode2.toStringWithDeclarationCoords() + ".");
                return false;
            }
        }
        if (typeNode instanceof NodeTypeNode && typeNode2 instanceof EdgeTypeNode || typeNode instanceof EdgeTypeNode && typeNode2 instanceof NodeTypeNode) {
            this.owner.reportError("Cannot initialize an attribute of type " + typeNode.toStringWithDeclarationCoords() + " with a value of type " + typeNode2.toStringWithDeclarationCoords() + ".");
            return false;
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return this.getIR();
        }
        NameOrAttributeInitialization nameOrAttributeInitialization = new NameOrAttributeInitialization();
        this.setIR(nameOrAttributeInitialization);
        assert (this.ownerIR != null);
        nameOrAttributeInitialization.owner = this.ownerIR;
        if (this.attribute != null) {
            nameOrAttributeInitialization.attribute = this.attribute.checkIR(Entity.class);
        }
        this.initialization = this.initialization.evaluate();
        nameOrAttributeInitialization.expr = this.initialization.checkIR(Expression.class);
        return nameOrAttributeInitialization;
    }
}

