/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.pattern;

import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.SubpatternUsageDeclNode;
import de.unika.ipd.grgen.ast.pattern.OrderedReplacementNode;
import de.unika.ipd.grgen.ast.pattern.OrderedReplacementsNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.pattern.SubpatternReplNode;
import de.unika.ipd.grgen.ast.pattern.TotallyHomNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.Exec;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.NeededEntities;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.GraphEntityExpression;
import de.unika.ipd.grgen.ir.expr.Operator;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.expr.Typeof;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.PatternGraphRhs;
import de.unika.ipd.grgen.ir.pattern.RetypedEdge;
import de.unika.ipd.grgen.ir.pattern.RetypedNode;
import de.unika.ipd.grgen.ir.pattern.SubpatternDependentReplacement;
import de.unika.ipd.grgen.ir.pattern.SubpatternUsage;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.EvalStatements;
import de.unika.ipd.grgen.ir.stmt.ImperativeStmt;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class PatternGraphBuilder {
    public static void addElementsHiddenInUsedConstructs(PatternGraphLhsNode patternGraphLhsNode, PatternGraphLhs patternGraphLhs) {
        for (SubpatternUsageDeclNode iterator : patternGraphLhsNode.subpatterns.getChildren()) {
            PatternGraphBuilder.addSubpatternUsageArgument(patternGraphLhs, iterator);
        }
        for (SubpatternUsageDeclNode subpatternUsageDeclNode : patternGraphLhsNode.subpatterns.getChildren()) {
            PatternGraphBuilder.addSubpatternUsageYieldArgument(patternGraphLhs, subpatternUsageDeclNode);
        }
        for (Node node : patternGraphLhs.getNodes()) {
            PatternGraphBuilder.addNodeFromTypeof(patternGraphLhs, node);
        }
        for (Edge edge : patternGraphLhs.getEdges()) {
            PatternGraphBuilder.addEdgeFromTypeof(patternGraphLhs, edge);
        }
        Object object = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.VARS, NeededEntities.Needs.CONTAINER_EXPRS));
        for (Expression expression : patternGraphLhs.getConditions()) {
            expression.collectNeededEntities((NeededEntities)object);
        }
        PatternGraphBuilder.addNeededEntities(patternGraphLhs, (NeededEntities)object);
        object = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.VARS, NeededEntities.Needs.CONTAINER_EXPRS));
        for (EvalStatements evalStatements : patternGraphLhs.getYields()) {
            evalStatements.collectNeededEntities((NeededEntities)object);
        }
        PatternGraphBuilder.addNeededEntities(patternGraphLhs, (NeededEntities)object);
        for (Collection<? extends GraphEntity> collection : patternGraphLhs.getHomomorphic()) {
            PatternGraphBuilder.addHomElements(patternGraphLhs, collection);
        }
        for (Node node : patternGraphLhs.getNodes()) {
            PatternGraphBuilder.addElementsFromStorageAccess(patternGraphLhs, node);
        }
        for (Node node : patternGraphLhs.getNodes()) {
            if (!(node instanceof RetypedNode) || node.isRHSEntity()) continue;
            patternGraphLhs.addNodeIfNotYetContained(((RetypedNode)node).getOldNode());
        }
        for (Edge edge : patternGraphLhs.getEdges()) {
            PatternGraphBuilder.addElementsFromStorageAccess(patternGraphLhs, edge);
        }
        for (Edge edge : patternGraphLhs.getEdges()) {
            if (!(edge instanceof RetypedEdge) || edge.isRHSEntity()) continue;
            patternGraphLhs.addEdgeIfNotYetContained(((RetypedEdge)edge).getOldEdge());
        }
        object = new NeededEntities(EnumSet.of(NeededEntities.Needs.NODES, NeededEntities.Needs.EDGES, NeededEntities.Needs.VARS, NeededEntities.Needs.CONTAINER_EXPRS));
        for (Node node : patternGraphLhs.getNodes()) {
            if (node.indexAccess == null) continue;
            node.indexAccess.collectNeededEntities((NeededEntities)object);
        }
        for (Edge edge : patternGraphLhs.getEdges()) {
            if (edge.indexAccess == null) continue;
            edge.indexAccess.collectNeededEntities((NeededEntities)object);
        }
        PatternGraphBuilder.addNeededEntities(patternGraphLhs, (NeededEntities)object);
    }

    public static void genTypeConditionsFromTypeof(PatternGraphLhs patternGraphLhs, GraphEntity graphEntity) {
        if (graphEntity.inheritsType()) {
            assert (graphEntity.getCopy() == ConstraintDeclNode.CopyKind.None);
            Typeof typeof = new Typeof(graphEntity);
            Typeof typeof2 = new Typeof(graphEntity.getTypeof());
            Operator operator = new Operator(BasicTypeNode.booleanType.getPrimitiveType(), Operator.OperatorCode.GE);
            operator.addOperand(typeof);
            operator.addOperand(typeof2);
            patternGraphLhs.addCondition(operator);
        }
    }

    private static void addSubpatternUsageArgument(PatternGraphLhs patternGraphLhs, SubpatternUsageDeclNode subpatternUsageDeclNode) {
        List<Expression> list = subpatternUsageDeclNode.checkIR(SubpatternUsage.class).getSubpatternConnections();
        for (Expression expression : list) {
            Object object;
            if (expression instanceof GraphEntityExpression) {
                object = ((GraphEntityExpression)expression).getGraphEntity();
                if (object instanceof Node) {
                    patternGraphLhs.addNodeIfNotYetContained((Node)object);
                    continue;
                }
                if (object instanceof Edge) {
                    patternGraphLhs.addEdgeIfNotYetContained((Edge)object);
                    continue;
                }
                assert (false);
                continue;
            }
            object = new NeededEntities(EnumSet.of(NeededEntities.Needs.VARS));
            expression.collectNeededEntities((NeededEntities)object);
            for (Variable variable : ((NeededEntities)object).variables) {
                if (patternGraphLhs.hasVar(variable)) continue;
                patternGraphLhs.addVariable(variable);
            }
        }
    }

    private static void addSubpatternUsageYieldArgument(PatternGraphLhs patternGraphLhs, SubpatternUsageDeclNode subpatternUsageDeclNode) {
        List<Expression> list = subpatternUsageDeclNode.checkIR(SubpatternUsage.class).getSubpatternYields();
        for (Expression expression : list) {
            Object object;
            if (expression instanceof GraphEntityExpression) {
                object = ((GraphEntityExpression)expression).getGraphEntity();
                if (object instanceof Node) {
                    patternGraphLhs.addNodeIfNotYetContained((Node)object);
                    continue;
                }
                if (object instanceof Edge) {
                    patternGraphLhs.addEdgeIfNotYetContained((Edge)object);
                    continue;
                }
                assert (false);
                continue;
            }
            object = new NeededEntities(EnumSet.of(NeededEntities.Needs.VARS));
            expression.collectNeededEntities((NeededEntities)object);
            for (Variable variable : ((NeededEntities)object).variables) {
                if (patternGraphLhs.hasVar(variable)) continue;
                patternGraphLhs.addVariable(variable);
            }
        }
    }

    private static void addNodeFromTypeof(PatternGraphLhs patternGraphLhs, Node node) {
        if (node.inheritsType()) {
            patternGraphLhs.addNodeIfNotYetContained((Node)node.getTypeof());
        }
    }

    private static void addEdgeFromTypeof(PatternGraphLhs patternGraphLhs, Edge edge) {
        if (edge.inheritsType()) {
            patternGraphLhs.addEdgeIfNotYetContained((Edge)edge.getTypeof());
        }
    }

    private static void addHomElements(PatternGraphLhs patternGraphLhs, Collection<? extends GraphEntity> collection) {
        for (GraphEntity graphEntity : collection) {
            if (graphEntity instanceof Node) {
                patternGraphLhs.addNodeIfNotYetContained((Node)graphEntity);
                continue;
            }
            patternGraphLhs.addEdgeIfNotYetContained((Edge)graphEntity);
        }
    }

    private static void addElementsFromStorageAccess(PatternGraphLhs patternGraphLhs, Node node) {
        IR iR;
        if (node.storageAccess != null) {
            if (node.storageAccess.storageVariable != null) {
                iR = node.storageAccess.storageVariable;
                if (!patternGraphLhs.hasVar((Variable)iR)) {
                    patternGraphLhs.addVariable((Variable)iR);
                }
            } else if (node.storageAccess.storageAttribute != null) {
                iR = node.storageAccess.storageAttribute;
                if (((Qualification)iR).getOwner() instanceof Node) {
                    patternGraphLhs.addNodeIfNotYetContained((Node)((Qualification)iR).getOwner());
                } else if (((Qualification)iR).getOwner() instanceof Edge) {
                    patternGraphLhs.addEdgeIfNotYetContained((Edge)((Qualification)iR).getOwner());
                }
            }
        }
        if (node.storageAccessIndex != null && node.storageAccessIndex.indexGraphEntity != null) {
            iR = node.storageAccessIndex.indexGraphEntity;
            if (iR instanceof Node) {
                patternGraphLhs.addNodeIfNotYetContained((Node)iR);
            } else if (iR instanceof Edge) {
                patternGraphLhs.addEdgeIfNotYetContained((Edge)iR);
            }
        }
    }

    private static void addElementsFromStorageAccess(PatternGraphLhs patternGraphLhs, Edge edge) {
        IR iR;
        if (edge.storageAccess != null) {
            if (edge.storageAccess.storageVariable != null) {
                iR = edge.storageAccess.storageVariable;
                if (!patternGraphLhs.hasVar((Variable)iR)) {
                    patternGraphLhs.addVariable((Variable)iR);
                }
            } else if (edge.storageAccess.storageAttribute != null) {
                iR = edge.storageAccess.storageAttribute;
                if (((Qualification)iR).getOwner() instanceof Node) {
                    patternGraphLhs.addNodeIfNotYetContained((Node)((Qualification)iR).getOwner());
                } else if (((Qualification)iR).getOwner() instanceof Edge) {
                    patternGraphLhs.addEdgeIfNotYetContained((Edge)((Qualification)iR).getOwner());
                }
            }
        }
        if (edge.storageAccessIndex != null && edge.storageAccessIndex.indexGraphEntity != null) {
            iR = edge.storageAccessIndex.indexGraphEntity;
            if (iR instanceof Node) {
                patternGraphLhs.addNodeIfNotYetContained((Node)iR);
            } else if (iR instanceof Edge) {
                patternGraphLhs.addEdgeIfNotYetContained((Edge)iR);
            }
        }
    }

    protected static void addNeededEntities(PatternGraphLhs patternGraphLhs, NeededEntities neededEntities) {
        for (Node entity : neededEntities.nodes) {
            patternGraphLhs.addNodeIfNotYetContained(entity);
        }
        for (Edge edge : neededEntities.edges) {
            patternGraphLhs.addEdgeIfNotYetContained(edge);
        }
        for (Variable variable : neededEntities.variables) {
            if (patternGraphLhs.hasVar(variable)) continue;
            patternGraphLhs.addVariable(variable);
        }
    }

    public static void addHoms(PatternGraphLhs patternGraphLhs, Set<ConstraintDeclNode> set) {
        if (set.iterator().next() instanceof NodeDeclNode) {
            HashSet<Node> hashSet = new HashSet<Node>();
            for (DeclNode declNode : set) {
                hashSet.add(declNode.checkIR(Node.class));
            }
            patternGraphLhs.addHomomorphicNodes(hashSet);
        } else {
            HashSet<Edge> hashSet = new HashSet<Edge>();
            for (DeclNode declNode : set) {
                hashSet.add(declNode.checkIR(Edge.class));
            }
            patternGraphLhs.addHomomorphicEdges(hashSet);
        }
    }

    public static void addTotallyHom(PatternGraphLhs patternGraphLhs, TotallyHomNode totallyHomNode) {
        if (totallyHomNode.node != null) {
            HashSet<Node> hashSet = new HashSet<Node>();
            for (NodeDeclNode nodeDeclNode : totallyHomNode.childrenNode) {
                hashSet.add(nodeDeclNode.checkIR(Node.class));
            }
            patternGraphLhs.addTotallyHomomorphic(totallyHomNode.node.checkIR(Node.class), hashSet);
        } else {
            HashSet<Edge> hashSet = new HashSet<Edge>();
            for (EdgeDeclNode edgeDeclNode : totallyHomNode.childrenEdge) {
                hashSet.add(edgeDeclNode.checkIR(Edge.class));
            }
            patternGraphLhs.addTotallyHomomorphic(totallyHomNode.edge.checkIR(Edge.class), hashSet);
        }
    }

    public static void ensureDefNodesAreHomToAllOthers(PatternGraphLhs patternGraphLhs, Node node) {
        if (node.isDefToBeYieldedTo()) {
            patternGraphLhs.addHomToAll(node);
        }
    }

    public static void ensureDefEdgesAreHomToAllOthers(PatternGraphLhs patternGraphLhs, Edge edge) {
        if (edge.isDefToBeYieldedTo()) {
            patternGraphLhs.addHomToAll(edge);
        }
    }

    public static void ensureRetypedNodeHomToOldNode(PatternGraphLhs patternGraphLhs, Node node) {
        if (node instanceof RetypedNode && !node.isRHSEntity()) {
            Vector<Node> vector = new Vector<Node>();
            vector.add(node);
            vector.add(((RetypedNode)node).getOldNode());
            patternGraphLhs.addHomomorphicNodes(vector);
        }
    }

    public static void ensureRetypedEdgeHomToOldEdge(PatternGraphLhs patternGraphLhs, Edge edge) {
        if (edge instanceof RetypedEdge && !edge.isRHSEntity()) {
            Vector<Edge> vector = new Vector<Edge>();
            vector.add(edge);
            vector.add(((RetypedEdge)edge).getOldEdge());
            patternGraphLhs.addHomomorphicEdges(vector);
        }
    }

    public static void addSubpatternReplacementUsageArguments(PatternGraphRhs patternGraphRhs, OrderedReplacementsNode orderedReplacementsNode) {
        for (OrderedReplacementNode orderedReplacementNode : orderedReplacementsNode.getChildren()) {
            if (!(orderedReplacementNode instanceof SubpatternReplNode)) continue;
            SubpatternReplNode subpatternReplNode = (SubpatternReplNode)orderedReplacementNode;
            SubpatternDependentReplacement subpatternDependentReplacement = subpatternReplNode.checkIR(SubpatternDependentReplacement.class);
            List<Expression> list = subpatternDependentReplacement.getReplConnections();
            for (Expression expression : list) {
                PatternGraphBuilder.addSubpatternReplacementUsageArgument(patternGraphRhs, expression);
            }
        }
    }

    private static void addSubpatternReplacementUsageArgument(PatternGraphRhs patternGraphRhs, Expression expression) {
        if (expression instanceof GraphEntityExpression) {
            GraphEntity graphEntity = ((GraphEntityExpression)expression).getGraphEntity();
            if (graphEntity instanceof Node) {
                patternGraphRhs.addNodeIfNotYetContained((Node)graphEntity);
            } else if (graphEntity instanceof Edge) {
                patternGraphRhs.addEdgeIfNotYetContained((Edge)graphEntity);
            } else assert (false);
        } else {
            NeededEntities neededEntities = new NeededEntities(EnumSet.of(NeededEntities.Needs.VARS));
            expression.collectNeededEntities(neededEntities);
            for (Variable variable : neededEntities.variables) {
                if (patternGraphRhs.hasVar(variable)) continue;
                patternGraphRhs.addVariable(variable);
            }
        }
    }

    public static void addElementsUsedInDeferredExec(PatternGraphRhs patternGraphRhs, ImperativeStmt imperativeStmt) {
        if (imperativeStmt instanceof Exec) {
            Set<Entity> set = ((Exec)imperativeStmt).getNeededEntities(false);
            for (Entity entity : set) {
                if (entity instanceof Node) {
                    patternGraphRhs.addNodeIfNotYetContained((Node)entity);
                    continue;
                }
                if (entity instanceof Edge) {
                    patternGraphRhs.addEdgeIfNotYetContained((Edge)entity);
                    continue;
                }
                if (patternGraphRhs.hasVar((Variable)entity)) continue;
                patternGraphRhs.addVariable((Variable)entity);
            }
        }
    }
}

