/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.pattern;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.model.type.DirectedEdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.model.type.UndirectedEdgeTypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationPairResolver;
import de.unika.ipd.grgen.ast.util.Pair;
import de.unika.ipd.grgen.ast.util.TypeChecker;
import de.unika.ipd.grgen.parser.Coords;
import java.awt.Color;
import java.util.Collection;
import java.util.Vector;

public class TotallyHomNode
extends BaseNode {
    NodeDeclNode node;
    EdgeDeclNode edge;
    Vector<NodeDeclNode> childrenNode = new Vector();
    Vector<EdgeDeclNode> childrenEdge = new Vector();
    private BaseNode entityUnresolved;
    private Vector<BaseNode> childrenUnresolved = new Vector();
    private static final DeclarationPairResolver<NodeDeclNode, EdgeDeclNode> declResolver;
    private static final TypeChecker nodeTypeChecker;
    private static final TypeChecker edgeTypeChecker;

    public TotallyHomNode(Coords coords) {
        super(coords);
    }

    public void setTotallyHom(BaseNode baseNode) {
        assert (this.entityUnresolved == null);
        this.becomeParent(baseNode);
        this.entityUnresolved = baseNode;
    }

    public void addChild(BaseNode baseNode) {
        assert (!this.isResolved());
        this.becomeParent(baseNode);
        this.childrenUnresolved.add(baseNode);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.entityUnresolved, this.node, this.edge));
        vector.addAll(this.getValidVersionVector(this.childrenUnresolved, this.childrenNode, this.childrenEdge));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("totally homomorph entity");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl;
        Object object = declResolver.resolve(this.entityUnresolved, this);
        boolean bl2 = bl = object != null;
        if (object != null) {
            if (((Pair)object).fst != null) {
                this.node = (NodeDeclNode)((Pair)object).fst;
            } else {
                this.edge = (EdgeDeclNode)((Pair)object).snd;
            }
        }
        for (int i = 0; i < this.childrenUnresolved.size(); ++i) {
            object = declResolver.resolve(this.childrenUnresolved.get(i), this);
            boolean bl3 = bl = object != null && bl;
            if (object == null) continue;
            if (((Pair)object).fst != null) {
                this.childrenNode.add((NodeDeclNode)((Pair)object).fst);
            }
            if (((Pair)object).snd == null) continue;
            this.childrenEdge.add((EdgeDeclNode)((Pair)object).snd);
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        if (this.node != null && !this.childrenEdge.isEmpty()) {
            this.reportError("The independent statement may only contain nodes or edges at a time (it specifies the node " + this.node.getIdentNode() + " to be totally homomorphic, but the edge " + this.childrenEdge.get(0) + " as exception to be isomorphic).");
            return false;
        }
        if (this.edge != null && !this.childrenNode.isEmpty()) {
            this.reportError("The independent statement may only contain nodes or edges at a time (it specifies the edge " + this.edge.getIdentNode() + " to be totally homomorphic, but the node " + this.childrenNode.get(0) + " as exception to be isomorphic).");
            return false;
        }
        boolean bl = true;
        for (NodeDeclNode constraintDeclNode : this.childrenNode) {
            bl = nodeTypeChecker.check(constraintDeclNode, error) && bl;
        }
        for (EdgeDeclNode edgeDeclNode : this.childrenEdge) {
            bl = edgeTypeChecker.check(edgeDeclNode, error) && bl;
        }
        if (this.edge != null) {
            this.warnEdgeTypes();
        }
        return bl;
    }

    private void warnEdgeTypes() {
        boolean bl = this.edge.getDeclType() instanceof DirectedEdgeTypeNode;
        boolean bl2 = this.edge.getDeclType() instanceof UndirectedEdgeTypeNode;
        for (int i = 0; i < this.childrenEdge.size(); ++i) {
            EdgeTypeNode edgeTypeNode = this.childrenEdge.get(i).getDeclType();
            if (edgeTypeNode instanceof DirectedEdgeTypeNode) {
                bl = true;
            }
            if (!(edgeTypeNode instanceof UndirectedEdgeTypeNode)) continue;
            bl2 = true;
        }
        if (bl && bl2) {
            this.reportWarning("The independent statement may only contain directed or undirected edges at a time.");
        }
    }

    @Override
    public Color getNodeColor() {
        return Color.PINK;
    }

    static {
        TotallyHomNode.setName(TotallyHomNode.class, "totally homomorph");
        declResolver = new DeclarationPairResolver<NodeDeclNode, EdgeDeclNode>(NodeDeclNode.class, EdgeDeclNode.class);
        nodeTypeChecker = new TypeChecker(NodeTypeNode.class);
        edgeTypeChecker = new TypeChecker(EdgeTypeNode.class);
    }
}

