/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ArithmeticOperatorNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.DeclExprNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.expr.MemberAccessExprNode;
import de.unika.ipd.grgen.ast.expr.OperatorNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.expr.map.MapInitNode;
import de.unika.ipd.grgen.ast.expr.set.SetInitNode;
import de.unika.ipd.grgen.ast.model.decl.MemberDeclNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.InheritanceTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ast.type.container.SetTypeNode;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.Edge;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Node;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.Assignment;
import de.unika.ipd.grgen.ir.stmt.AssignmentGraphEntity;
import de.unika.ipd.grgen.ir.stmt.AssignmentIdentical;
import de.unika.ipd.grgen.ir.stmt.AssignmentMember;
import de.unika.ipd.grgen.ir.stmt.AssignmentVar;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

public class AssignNode
extends EvalStatementNode {
    BaseNode lhsUnresolved;
    ExprNode rhs;
    int context;
    boolean onLHS;
    QualIdentNode lhsQual;
    VarDeclNode lhsVar;
    ConstraintDeclNode lhsGraphElement;
    MemberDeclNode lhsMember;

    public AssignNode(Coords coords, QualIdentNode qualIdentNode, ExprNode exprNode, int n) {
        super(coords);
        this.lhsUnresolved = qualIdentNode;
        this.becomeParent(this.lhsUnresolved);
        this.rhs = exprNode;
        this.becomeParent(this.rhs);
        this.context = n;
        this.onLHS = false;
    }

    public AssignNode(Coords coords, IdentExprNode identExprNode, ExprNode exprNode, int n, boolean bl) {
        super(coords);
        this.lhsUnresolved = identExprNode;
        this.becomeParent(this.lhsUnresolved);
        this.rhs = exprNode;
        this.becomeParent(this.rhs);
        this.context = n;
        this.onLHS = bl;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.lhsUnresolved, this.lhsQual, this.lhsVar, this.lhsGraphElement));
        vector.add(this.rhs);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("lhs");
        vector.add("rhs");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        if (this.lhsUnresolved instanceof IdentExprNode) {
            IdentExprNode identExprNode = (IdentExprNode)this.lhsUnresolved;
            if (identExprNode.resolve()) {
                if (identExprNode.decl instanceof VarDeclNode) {
                    this.lhsVar = (VarDeclNode)identExprNode.decl;
                } else if (identExprNode.decl instanceof ConstraintDeclNode) {
                    this.lhsGraphElement = (ConstraintDeclNode)identExprNode.decl;
                } else if (identExprNode.decl instanceof MemberDeclNode) {
                    this.reportError("Error in resolving the left hand side of the assignment (given is " + identExprNode.getIdent() + ") (use this." + identExprNode.getIdent() + " to access a class member inside a method).");
                    bl = false;
                } else {
                    this.reportError("Error in resolving the left hand side of the assignment, a variable or graph element is expected (given is " + identExprNode.getIdent() + ").");
                    bl = false;
                }
            } else {
                this.reportError("Error in resolving the left hand side of the assignment (given is " + identExprNode.getIdent() + ").");
                bl = false;
            }
        } else if (this.lhsUnresolved instanceof QualIdentNode) {
            QualIdentNode qualIdentNode = (QualIdentNode)this.lhsUnresolved;
            if (qualIdentNode.resolve()) {
                this.lhsQual = qualIdentNode;
            } else {
                this.reportError("Error in resolving the qualified attribute on the left hand side of the assignment (given is " + qualIdentNode + ").");
                bl = false;
            }
        } else {
            this.reportError("Internal error - invalid left hand side in assignment.");
            bl = false;
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        if (this.lhsQual != null ? !this.checkLhsQual() : (this.lhsGraphElement != null ? !this.checkLhsGraphElement() : this.lhsVar != null && !this.checkLhsVar())) {
            return false;
        }
        return this.typeCheckLocal();
    }

    private boolean checkLhsQual() {
        BaseNode baseNode;
        if ((this.context & 0x80) == 0 && !this.lhsQual.isMatchAssignment() && !this.lhsQual.isTransientObjectAssignment()) {
            this.reportError("An assignment to an attribute of a graph element or internal class object is not allowed in function or pattern part context (but occurrs with " + this.lhsQual + ").");
            return false;
        }
        DeclNode declNode = this.lhsQual.getOwner();
        TypeNode typeNode = declNode.getDeclType();
        MemberDeclNode memberDeclNode = this.lhsQual.getDecl();
        if (memberDeclNode != null && memberDeclNode.isConst()) {
            this.reportError("An assignment to a const member is not allowed (" + this.lhsQual.getDecl().getIdentNode() + this.lhsQual.getDecl().getDeclarationCoords() + " is constant).");
            return false;
        }
        if (typeNode instanceof InheritanceTypeNode && ((InheritanceTypeNode)(baseNode = (InheritanceTypeNode)typeNode)).isConst()) {
            this.reportError("An assignment to a const type object is not allowed (" + baseNode.toStringWithDeclarationCoords() + " is constant).");
            return false;
        }
        if (declNode instanceof ConstraintDeclNode) {
            baseNode = (ConstraintDeclNode)declNode;
            if ((((ConstraintDeclNode)baseNode).context & 0x40) == 64 && this.getCoords().comesBefore(baseNode.getCoords())) {
                this.reportError("Variables (node,edge,var,ref) of computations must be declared before they can be assigned to (" + ((DeclNode)baseNode).getIdentNode() + " was not yet declared).");
                return false;
            }
        }
        return true;
    }

    private boolean checkLhsGraphElement() {
        if (this.lhsGraphElement.defEntityToBeYieldedTo) {
            IdentExprNode identExprNode = (IdentExprNode)this.lhsUnresolved;
            if ((this.lhsGraphElement.context & 0x40) != 64) {
                if (!identExprNode.yieldedTo) {
                    this.reportError("Only a yield assignment is allowed to a def pattern graph element (" + this.lhsGraphElement.getIdentNode() + " was declared with def) (the typical solution is to prepend a yield to the assignment).");
                    return false;
                }
            } else if (identExprNode.yieldedTo) {
                this.reportError("Only a non-yield assignment is allowed to a computation local def pattern graph element (" + this.lhsGraphElement.getIdentNode() + " was declared with def in computation context) (the typical solution is to remove the yield from the assignment).");
                return false;
            }
            if ((this.lhsGraphElement.context & 0x40) != 64 && (this.lhsGraphElement.context & 1) == 0 && (this.context & 1) == 1) {
                this.reportError("Cannot yield from the right hand side to a left hand side def pattern graph element (" + this.lhsGraphElement.getIdentNode() + " was declared in the pattern part).");
                return false;
            }
        } else {
            if (this.lhsGraphElement.directlyNestingLHSGraph != null) {
                IdentExprNode identExprNode = (IdentExprNode)this.lhsUnresolved;
                if (identExprNode.yieldedTo) {
                    this.reportError("A yield assignment is only allowed to a def pattern graph element (" + this.lhsGraphElement.getIdentNode() + " was declared without def).");
                    return false;
                }
                this.reportError("Only a def pattern graph element can be assigned to (" + this.lhsGraphElement.getIdentNode() + " was declared without def).");
                return false;
            }
            if (this.lhsGraphElement.directlyNestingLHSGraph == null && this.onLHS) {
                this.reportError("An assignment to a global variable (" + this.lhsGraphElement.toStringWithDeclarationCoords() + ") is not allowed from a yield block.");
                return false;
            }
        }
        if ((this.lhsGraphElement.context & 0x40) == 64 && this.getCoords().comesBefore(this.lhsGraphElement.getCoords())) {
            this.reportError("Variables (node,edge,var,ref) of computations must be declared before they can be assigned to (" + this.lhsGraphElement.getIdentNode() + " was not yet declared).");
            return false;
        }
        return true;
    }

    private boolean checkLhsVar() {
        if (this.lhsVar.defEntityToBeYieldedTo) {
            IdentExprNode identExprNode = (IdentExprNode)this.lhsUnresolved;
            if ((this.lhsVar.context & 0x40) != 64) {
                if (!identExprNode.yieldedTo) {
                    this.reportError("Only a yield assignment is allowed to a def variable (" + this.lhsVar.getIdentNode() + " was declared with def) (the typical solution is to prepend a yield to the assignment).");
                    return false;
                }
            } else if (identExprNode.yieldedTo) {
                this.reportError("Only a non-yield assignment is allowed to a computation local def variable (" + this.lhsVar.getIdentNode() + " was declared with def in computation context) (the typical solution is to remove the yield from the assignment).");
                return false;
            }
            if ((this.lhsVar.context & 0x40) != 64 && (this.lhsVar.context & 1) == 0 && (this.context & 1) == 1) {
                this.reportError("Cannot yield from the right hand side to a left hand side def variable (" + this.lhsVar.getIdentNode() + " was declared in the pattern part).");
                return false;
            }
        } else {
            IdentExprNode identExprNode = (IdentExprNode)this.lhsUnresolved;
            if (identExprNode.yieldedTo) {
                this.reportError("A yield assignment is only allowed to a def variable (" + this.lhsVar.getIdentNode() + " was declared without def).");
                return false;
            }
            if (this.lhsVar.directlyNestingLHSGraph == null && this.onLHS) {
                this.reportError("An assignment to a global variable (" + this.lhsVar.toStringWithDeclarationCoords() + ") is not allowed from a yield block.");
                return false;
            }
        }
        if ((this.lhsVar.context & 0x40) == 64 && this.getCoords().comesBefore(this.lhsVar.getCoords())) {
            this.reportError("Variables (node,edge,var,ref) of computations must be declared before they can be assigned to (" + this.lhsVar.getIdentNode() + " was not yet declared).");
            return false;
        }
        return true;
    }

    private boolean typeCheckLocal() {
        TypeNode typeNode;
        TypeNode typeNode2 = null;
        if (this.lhsQual != null) {
            typeNode2 = !this.lhsQual.isMatchAssignment() ? this.lhsQual.getDecl().getDeclType() : this.lhsQual.getMember().getDeclType();
        }
        if (this.lhsVar != null) {
            typeNode2 = this.lhsVar.getDeclType();
        }
        if (this.lhsGraphElement != null) {
            typeNode2 = this.lhsGraphElement.getDeclType();
        }
        if (this.lhsMember != null) {
            typeNode2 = this.lhsMember.getDeclType();
        }
        if ((typeNode = this.rhs.getType()).isEqual(typeNode2)) {
            return true;
        }
        this.rhs = this.becomeParent(this.rhs.adjustType(typeNode2, this.getCoords()));
        if (this.rhs == ConstNode.getInvalid()) {
            return false;
        }
        if (typeNode2 instanceof NodeTypeNode && typeNode instanceof NodeTypeNode || typeNode2 instanceof EdgeTypeNode && typeNode instanceof EdgeTypeNode) {
            HashSet<TypeNode> hashSet = new HashSet<TypeNode>();
            typeNode.doGetCompatibleToTypes(hashSet);
            if (!hashSet.contains(typeNode2)) {
                this.reportError("Cannot assign a value of type " + typeNode.toStringWithDeclarationCoords() + " to a variable of type " + typeNode2.toStringWithDeclarationCoords() + ".");
                return false;
            }
        }
        if (typeNode2 instanceof NodeTypeNode && typeNode instanceof EdgeTypeNode || typeNode2 instanceof EdgeTypeNode && typeNode instanceof NodeTypeNode) {
            this.reportError("Cannot assign a value of type " + typeNode.toStringWithDeclarationCoords() + " to a variable of type " + typeNode2.toStringWithDeclarationCoords() + ".");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        if (this.isIdenticalAssignment()) {
            return new AssignmentIdentical();
        }
        ExprNode exprNode = this.rhs.evaluate();
        if (this.lhsQual != null) {
            Qualification qualification = this.lhsQual.checkIR(Qualification.class);
            if (qualification.getOwner() instanceof Node && ((Node)qualification.getOwner()).changesType(null)) {
                this.reportError("An assignment to a node whose type will be changed is not allowed (but occurs for " + this.lhsQual + ").");
            }
            if (qualification.getOwner() instanceof Edge && ((Edge)qualification.getOwner()).changesType(null)) {
                this.reportError("An assignment to an edge whose type will be changed is not allowed (but occurs for " + this.lhsQual + ").");
            }
            if (this.canSetOrMapAssignmentBeBrokenUpIntoStateChangingOperations()) {
                this.markSetOrMapAssignmentToBeBrokenUpIntoStateChangingOperations();
                return exprNode.checkIR(EvalStatement.class);
            }
            return new Assignment(qualification, exprNode.checkIR(Expression.class));
        }
        if (this.lhsVar != null) {
            Variable variable = this.lhsVar.checkIR(Variable.class);
            return new AssignmentVar(variable, exprNode.checkIR(Expression.class));
        }
        if (this.lhsGraphElement != null) {
            GraphEntity graphEntity = this.lhsGraphElement.checkIR(GraphEntity.class);
            return new AssignmentGraphEntity(graphEntity, exprNode.checkIR(Expression.class));
        }
        Entity entity = this.lhsMember.checkIR(Entity.class);
        return new AssignmentMember(entity, exprNode.checkIR(Expression.class));
    }

    private boolean canSetOrMapAssignmentBeBrokenUpIntoStateChangingOperations() {
        if (this.lhsQual == null || this.lhsQual.getDecl() == null) {
            return false;
        }
        QualIdentNode qualIdentNode = this.lhsQual;
        if (!(qualIdentNode.getDecl().type instanceof SetTypeNode) && !(qualIdentNode.getDecl().type instanceof MapTypeNode)) {
            return false;
        }
        ExprNode exprNode = this.rhs;
        while (exprNode != null) {
            BaseNode baseNode;
            BaseNode baseNode2;
            Object object;
            Object object2;
            ExprNode exprNode2;
            if (exprNode instanceof ArithmeticOperatorNode) {
                exprNode2 = (ArithmeticOperatorNode)exprNode;
                if (((OperatorNode)exprNode2).getOperatorDecl().getOperator() != OperatorDeclNode.Operator.BIT_OR && ((OperatorNode)exprNode2).getOperatorDecl().getOperator() != OperatorDeclNode.Operator.EXCEPT) {
                    return false;
                }
                object2 = ((ArithmeticOperatorNode)exprNode2).getChildren();
                object = object2.iterator();
                baseNode2 = (ExprNode)object.next();
                baseNode = (ExprNode)object.next();
                if (!(baseNode instanceof SetInitNode) && !(baseNode instanceof MapInitNode)) {
                    return false;
                }
                exprNode = baseNode2;
                continue;
            }
            if (exprNode instanceof MemberAccessExprNode) {
                exprNode2 = (MemberAccessExprNode)exprNode;
                if (!(((MemberAccessExprNode)exprNode2).getTarget() instanceof IdentExprNode)) {
                    return false;
                }
                object2 = (IdentExprNode)((MemberAccessExprNode)exprNode2).getTarget();
                if (!(((DeclExprNode)object2).getResolvedNode() instanceof ConstraintDeclNode)) {
                    return false;
                }
                object = (ConstraintDeclNode)((DeclExprNode)object2).getResolvedNode();
                baseNode2 = ((MemberAccessExprNode)exprNode2).getDecl();
                baseNode = qualIdentNode.getDecl();
                if (!(qualIdentNode.getOwner() instanceof ConstraintDeclNode)) {
                    return false;
                }
                ConstraintDeclNode constraintDeclNode = (ConstraintDeclNode)qualIdentNode.getOwner();
                if (constraintDeclNode != object) {
                    return false;
                }
                if (baseNode != baseNode2) {
                    return false;
                }
                exprNode = null;
                continue;
            }
            return false;
        }
        return true;
    }

    private void markSetOrMapAssignmentToBeBrokenUpIntoStateChangingOperations() {
        ExprNode exprNode = this.rhs;
        while (exprNode != null) {
            if (exprNode instanceof ArithmeticOperatorNode) {
                ExprNode exprNode2;
                ArithmeticOperatorNode arithmeticOperatorNode = (ArithmeticOperatorNode)exprNode;
                arithmeticOperatorNode.markToBreakUpIntoStateChangingOperations(this.lhsQual);
                exprNode = exprNode2 = (ExprNode)((Vector)arithmeticOperatorNode.getChildren()).iterator().next();
                continue;
            }
            exprNode = null;
        }
    }

    private boolean isIdenticalAssignment() {
        if (this.lhsQual != null) {
            if (this.rhs instanceof MemberAccessExprNode) {
                MemberAccessExprNode memberAccessExprNode = (MemberAccessExprNode)this.rhs;
                if (!(memberAccessExprNode.getTarget() instanceof IdentExprNode)) {
                    return false;
                }
                IdentExprNode identExprNode = (IdentExprNode)memberAccessExprNode.getTarget();
                if (this.lhsQual.getOwner() == identExprNode.decl.getDecl() && this.lhsQual.getDecl() == memberAccessExprNode.getDecl()) {
                    return true;
                }
            }
        } else if (this.rhs instanceof IdentExprNode) {
            IdentExprNode identExprNode = (IdentExprNode)this.rhs;
            if (this.lhsVar == identExprNode.decl.getDecl()) {
                return true;
            }
        }
        return false;
    }

    static {
        AssignNode.setName(AssignNode.class, "Assign");
    }
}

