/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.IdentExprNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.expr.graph.VisitedNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ast.type.container.DequeTypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ast.type.container.SetTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.expr.graph.Visited;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.CompoundAssignment;
import de.unika.ipd.grgen.ir.stmt.CompoundAssignmentChanged;
import de.unika.ipd.grgen.ir.stmt.CompoundAssignmentChangedVar;
import de.unika.ipd.grgen.ir.stmt.CompoundAssignmentChangedVisited;
import de.unika.ipd.grgen.ir.stmt.CompoundAssignmentVar;
import de.unika.ipd.grgen.ir.stmt.CompoundAssignmentVarChanged;
import de.unika.ipd.grgen.ir.stmt.CompoundAssignmentVarChangedVar;
import de.unika.ipd.grgen.ir.stmt.CompoundAssignmentVarChangedVisited;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class CompoundAssignNode
extends EvalStatementNode {
    private BaseNode targetUnresolved;
    private CompoundAssignmentType compoundAssignmentType;
    private ExprNode valueExpr;
    private BaseNode targetChangedUnresolved;
    private CompoundAssignmentType targetCompoundAssignmentType;
    private QualIdentNode targetQual;
    private VarDeclNode targetVar;
    private QualIdentNode targetChangedQual;
    private VarDeclNode targetChangedVar;
    private VisitedNode targetChangedVis;

    public CompoundAssignNode(Coords coords, BaseNode baseNode, CompoundAssignmentType compoundAssignmentType, ExprNode exprNode, CompoundAssignmentType compoundAssignmentType2, BaseNode baseNode2) {
        super(coords);
        this.targetUnresolved = this.becomeParent(baseNode);
        this.compoundAssignmentType = compoundAssignmentType;
        this.valueExpr = this.becomeParent(exprNode);
        this.targetChangedUnresolved = this.becomeParent(baseNode2);
        this.targetCompoundAssignmentType = compoundAssignmentType2;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.targetUnresolved, this.targetQual, this.targetVar));
        vector.add(this.valueExpr);
        if (this.targetChangedUnresolved != null) {
            vector.add(this.getValidVersion(this.targetChangedUnresolved, this.targetChangedQual, this.targetChangedVar, this.targetChangedVis));
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("target");
        vector.add("valueExpr");
        if (this.targetChangedUnresolved != null) {
            vector.add("targetChanged");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        BaseNode baseNode;
        boolean bl = true;
        if (this.targetUnresolved instanceof IdentExprNode) {
            baseNode = (IdentExprNode)this.targetUnresolved;
            if (baseNode.resolve() && ((IdentExprNode)baseNode).decl instanceof VarDeclNode) {
                this.targetVar = (VarDeclNode)((IdentExprNode)baseNode).decl;
            } else {
                this.reportError("Error in resolving the left hand side of the compound assignment, a parameter variable is expected (given is " + ((IdentExprNode)baseNode).getIdent() + ").");
                bl = false;
            }
        } else if (this.targetUnresolved instanceof QualIdentNode) {
            baseNode = (QualIdentNode)this.targetUnresolved;
            if (baseNode.resolve()) {
                this.targetQual = baseNode;
            } else {
                this.reportError("Error in resolving the left hand side of the compound assignment, a qualified attribute is expected (given is " + baseNode + ").");
                bl = false;
            }
        } else {
            this.reportError("Internal error - invalid left hand side in compound assignment.");
            bl = false;
        }
        if (this.targetChangedUnresolved != null) {
            if (this.targetChangedUnresolved instanceof IdentExprNode) {
                baseNode = (IdentExprNode)this.targetChangedUnresolved;
                if (baseNode.resolve() && ((IdentExprNode)baseNode).decl instanceof VarDeclNode) {
                    this.targetChangedVar = (VarDeclNode)((IdentExprNode)baseNode).decl;
                } else {
                    this.reportError("Error in resolving the changement assign target of the compound assignment, a parameter variable is expected (given is " + ((IdentExprNode)baseNode).getIdent() + ").");
                    bl = false;
                }
            } else if (this.targetChangedUnresolved instanceof QualIdentNode) {
                baseNode = (QualIdentNode)this.targetChangedUnresolved;
                if (baseNode.resolve()) {
                    this.targetChangedQual = baseNode;
                } else {
                    this.reportError("Error in resolving the changement assign target of the compound assignment, a qualified attribute is expected (given is " + baseNode + ").");
                    bl = false;
                }
            } else if (this.targetChangedUnresolved instanceof VisitedNode) {
                baseNode = (VisitedNode)this.targetChangedUnresolved;
                if (baseNode.resolve()) {
                    this.targetChangedVis = baseNode;
                } else {
                    this.reportError("Error in resolving the changement assign target of the compound assignment, a visited flag is expected (given is " + baseNode + ").");
                    bl = false;
                }
            } else {
                this.reportError("Internal error - invalid changement assign target in compound assignment.");
                bl = false;
            }
        }
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode;
        TypeNode typeNode2 = typeNode = this.targetQual != null ? this.targetQual.getDecl().getDeclType() : this.targetVar.getDeclType();
        if (this.compoundAssignmentType == CompoundAssignmentType.CONCATENATE && !(typeNode instanceof ArrayTypeNode) && !(typeNode instanceof DequeTypeNode)) {
            (this.targetQual != null ? this.targetQual : this.targetVar).reportError("Compound assignment expects a left hand side of array or deque type (given is type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        if (this.compoundAssignmentType != CompoundAssignmentType.CONCATENATE && !(typeNode instanceof SetTypeNode) && !(typeNode instanceof MapTypeNode)) {
            (this.targetQual != null ? this.targetQual : this.targetVar).reportError("Compound assignment expects a left hand side of set or map type (given is type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        TypeNode typeNode3 = this.valueExpr.getType();
        if (!typeNode3.isEqual(typeNode)) {
            this.valueExpr.reportError("Cannot compound-assign a value of type " + typeNode3.toStringWithDeclarationCoords() + " to a variable of type " + typeNode.toStringWithDeclarationCoords() + ".");
            return false;
        }
        if (this.targetChangedUnresolved != null) {
            TypeNode typeNode4 = null;
            if (this.targetChangedQual != null) {
                typeNode4 = this.targetChangedQual.getDecl().getDeclType();
            } else if (this.targetChangedVar != null) {
                typeNode4 = this.targetChangedVar.getDeclType();
            } else if (this.targetChangedVis != null) {
                typeNode4 = this.targetChangedVis.getType();
            }
            if (typeNode4 != BasicTypeNode.booleanType) {
                this.targetChangedUnresolved.reportError("The type of the target of the changement assignment of the compound assignment must be boolean (but given is " + typeNode4.toStringWithDeclarationCoords() + ").");
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.valueExpr = this.valueExpr.evaluate();
        if (this.targetQual != null) {
            if (this.targetChangedQual != null) {
                return new CompoundAssignmentChanged(this.targetQual.checkIR(Qualification.class), this.mapCompoundAssignmentType(this.compoundAssignmentType), this.valueExpr.checkIR(Expression.class), this.mapCompoundAssignmentType(this.targetCompoundAssignmentType), this.targetChangedQual.checkIR(Qualification.class));
            }
            if (this.targetChangedVar != null) {
                return new CompoundAssignmentChangedVar(this.targetQual.checkIR(Qualification.class), this.mapCompoundAssignmentType(this.compoundAssignmentType), this.valueExpr.checkIR(Expression.class), this.mapCompoundAssignmentType(this.targetCompoundAssignmentType), this.targetChangedVar.checkIR(Variable.class));
            }
            if (this.targetChangedVis != null) {
                return new CompoundAssignmentChangedVisited(this.targetQual.checkIR(Qualification.class), this.mapCompoundAssignmentType(this.compoundAssignmentType), this.valueExpr.checkIR(Expression.class), this.mapCompoundAssignmentType(this.targetCompoundAssignmentType), this.targetChangedVis.checkIR(Visited.class));
            }
            return new CompoundAssignment(this.targetQual.checkIR(Qualification.class), this.mapCompoundAssignmentType(this.compoundAssignmentType), this.valueExpr.checkIR(Expression.class));
        }
        if (this.targetChangedQual != null) {
            return new CompoundAssignmentVarChanged(this.targetVar.checkIR(Variable.class), this.mapCompoundAssignmentTypeVar(this.compoundAssignmentType), this.valueExpr.checkIR(Expression.class), this.mapCompoundAssignmentTypeVar(this.targetCompoundAssignmentType), this.targetChangedQual.checkIR(Qualification.class));
        }
        if (this.targetChangedVar != null) {
            return new CompoundAssignmentVarChangedVar(this.targetVar.checkIR(Variable.class), this.mapCompoundAssignmentTypeVar(this.compoundAssignmentType), this.valueExpr.checkIR(Expression.class), this.mapCompoundAssignmentTypeVar(this.targetCompoundAssignmentType), this.targetChangedVar.checkIR(Variable.class));
        }
        if (this.targetChangedVis != null) {
            return new CompoundAssignmentVarChangedVisited(this.targetVar.checkIR(Variable.class), this.mapCompoundAssignmentTypeVar(this.compoundAssignmentType), this.valueExpr.checkIR(Expression.class), this.mapCompoundAssignmentTypeVar(this.targetCompoundAssignmentType), this.targetChangedVis.checkIR(Visited.class));
        }
        return new CompoundAssignmentVar(this.targetVar.checkIR(Variable.class), this.mapCompoundAssignmentTypeVar(this.compoundAssignmentType), this.valueExpr.checkIR(Expression.class));
    }

    CompoundAssignment.CompoundAssignmentType mapCompoundAssignmentType(CompoundAssignmentType compoundAssignmentType) {
        switch (compoundAssignmentType) {
            case NONE: {
                return CompoundAssignment.CompoundAssignmentType.NONE;
            }
            case UNION: {
                return CompoundAssignment.CompoundAssignmentType.UNION;
            }
            case INTERSECTION: {
                return CompoundAssignment.CompoundAssignmentType.INTERSECTION;
            }
            case WITHOUT: {
                return CompoundAssignment.CompoundAssignmentType.WITHOUT;
            }
            case CONCATENATE: {
                return CompoundAssignment.CompoundAssignmentType.CONCATENATE;
            }
            case ASSIGN: {
                return CompoundAssignment.CompoundAssignmentType.ASSIGN;
            }
        }
        throw new RuntimeException("Internal failure");
    }

    CompoundAssignmentVar.CompoundAssignmentType mapCompoundAssignmentTypeVar(CompoundAssignmentType compoundAssignmentType) {
        switch (compoundAssignmentType) {
            case NONE: {
                return CompoundAssignmentVar.CompoundAssignmentType.NONE;
            }
            case UNION: {
                return CompoundAssignmentVar.CompoundAssignmentType.UNION;
            }
            case INTERSECTION: {
                return CompoundAssignmentVar.CompoundAssignmentType.INTERSECTION;
            }
            case WITHOUT: {
                return CompoundAssignmentVar.CompoundAssignmentType.WITHOUT;
            }
            case CONCATENATE: {
                return CompoundAssignmentVar.CompoundAssignmentType.CONCATENATE;
            }
            case ASSIGN: {
                return CompoundAssignmentVar.CompoundAssignmentType.ASSIGN;
            }
        }
        throw new RuntimeException("Internal failure");
    }

    static {
        CompoundAssignNode.setName(CompoundAssignNode.class, "compound assign statement");
    }

    public static enum CompoundAssignmentType {
        NONE,
        UNION,
        INTERSECTION,
        WITHOUT,
        CONCATENATE,
        ASSIGN;

    }
}

