/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.ConstraintDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.SingleNodeConnNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.util.Resolver;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.pattern.GraphEntity;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.DefDeclGraphEntityStatement;
import de.unika.ipd.grgen.ir.stmt.DefDeclVarStatement;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class DefDeclStatementNode
extends EvalStatementNode {
    BaseNode defDeclUnresolved;
    int context;
    VarDeclNode defDeclVar;
    ConstraintDeclNode defDeclGraphElement;

    public DefDeclStatementNode(Coords coords, BaseNode baseNode, int n) {
        super(coords);
        this.defDeclUnresolved = baseNode;
        this.becomeParent(this.defDeclUnresolved);
        this.context = n;
    }

    public DefDeclStatementNode(Coords coords, VarDeclNode varDeclNode, int n) {
        super(coords);
        this.defDeclVar = varDeclNode;
        this.context = n;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.defDeclUnresolved, this.defDeclVar, this.defDeclGraphElement));
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("defDecl");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl = true;
        DeclNode declNode = this.getDecl();
        if (declNode.typeUnresolved instanceof PackageIdentNode) {
            Resolver.resolveOwner((PackageIdentNode)declNode.typeUnresolved);
        } else {
            DefDeclStatementNode.fixupDefinition(declNode.typeUnresolved, declNode.typeUnresolved.getScope());
        }
        bl = declNode.resolve();
        return bl;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    public DeclNode getDecl() {
        if (this.defDeclUnresolved == null) {
            return this.defDeclVar;
        }
        if (this.defDeclUnresolved instanceof VarDeclNode) {
            this.defDeclVar = (VarDeclNode)this.defDeclUnresolved;
            return this.defDeclVar;
        }
        if (this.defDeclUnresolved instanceof SingleNodeConnNode) {
            SingleNodeConnNode singleNodeConnNode = (SingleNodeConnNode)this.defDeclUnresolved;
            this.defDeclGraphElement = (NodeDeclNode)singleNodeConnNode.nodeUnresolved;
            return this.defDeclGraphElement;
        }
        if (this.defDeclUnresolved instanceof ConstraintDeclNode) {
            this.defDeclGraphElement = (ConstraintDeclNode)this.defDeclUnresolved;
            return this.defDeclGraphElement;
        }
        ConnectionNode connectionNode = (ConnectionNode)this.defDeclUnresolved;
        this.defDeclGraphElement = (EdgeDeclNode)connectionNode.edgeUnresolved;
        return this.defDeclGraphElement;
    }

    @Override
    protected IR constructIR() {
        if (this.defDeclVar != null) {
            Variable variable = this.defDeclVar.checkIR(Variable.class);
            return new DefDeclVarStatement(variable);
        }
        GraphEntity graphEntity = this.defDeclGraphElement.checkIR(GraphEntity.class);
        return new DefDeclGraphEntityStatement(graphEntity);
    }

    static {
        DefDeclStatementNode.setName(DefDeclStatementNode.class, "def decl statement");
    }
}

