/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.NestingStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.DoWhileStatement;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class DoWhileStatementNode
extends NestingStatementNode {
    private ExprNode conditionExpr;

    public DoWhileStatementNode(Coords coords, CollectNode<EvalStatementNode> collectNode, ExprNode exprNode) {
        super(coords, collectNode);
        this.statements = collectNode;
        this.becomeParent(this.statements);
        this.conditionExpr = exprNode;
        this.becomeParent(exprNode);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.statements);
        vector.add(this.conditionExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("loopedStatements");
        vector.add("condition");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode = this.conditionExpr.getType();
        if (!typeNode.isEqual(BasicTypeNode.booleanType)) {
            this.conditionExpr.reportError("The condition of the do-while loop must be of type boolean (but is of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.conditionExpr = this.conditionExpr.evaluate();
        DoWhileStatement doWhileStatement = new DoWhileStatement(this.conditionExpr.checkIR(Expression.class));
        for (EvalStatementNode evalStatementNode : this.statements.getChildren()) {
            doWhileStatement.addStatement(evalStatementNode.checkIR(EvalStatement.class));
        }
        return doWhileStatement;
    }

    static {
        DoWhileStatementNode.setName(DoWhileStatementNode.class, "DoWhileStatement");
    }
}

