/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.ExecNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ir.Exec;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.stmt.ExecStatement;
import java.util.Collection;
import java.util.Vector;

public class ExecStatementNode
extends EvalStatementNode {
    ExecNode exec;
    public int context;

    public ExecStatementNode(ExecNode execNode, int n) {
        super(execNode.getCoords());
        this.exec = execNode;
        this.becomeParent(this.exec);
        this.context = n;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.exec);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("exec");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        if ((this.context & 0x40) == 64) {
            if ((this.context & 0x100) == 256) {
                this.reportError("An exec is not allowed in a method.");
                return false;
            }
            if ((this.context & 0x80) == 0) {
                this.reportError("An exec is not allowed in a function.");
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    public boolean noExecStatement(boolean bl) {
        if (bl) {
            this.reportError("An exec inside an evalhere is forbidden (you may move it outside the evalhere, but note that it is then executed at the end of rewriting).");
        } else {
            this.reportError("An exec inside an eval is forbidden in an alternative or iterated -- move it outside of the eval (so it becomes a deferred exec, executed at the end of rewriting, on the by-then current graph and the local entities valid at the end of its local rewriting).");
        }
        return false;
    }

    @Override
    protected IR constructIR() {
        ExecStatement execStatement = new ExecStatement(this.exec.checkIR(Exec.class));
        return execStatement;
    }

    static {
        ExecStatementNode.setName(ExecStatementNode.class, "ExecStatement");
    }
}

