/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.NestingStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.LockStatement;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class LockStatementNode
extends NestingStatementNode {
    private ExprNode lockObjectExpr;

    public LockStatementNode(Coords coords, ExprNode exprNode, CollectNode<EvalStatementNode> collectNode) {
        super(coords, collectNode);
        this.lockObjectExpr = exprNode;
        this.becomeParent(exprNode);
        this.statements = collectNode;
        this.becomeParent(this.statements);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.lockObjectExpr);
        vector.add(this.statements);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("lockObject");
        vector.add("lockedStatements");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode = this.lockObjectExpr.getType();
        if (!typeNode.isLockableType()) {
            this.lockObjectExpr.reportError("The lock statement expects as lock object a value that is not of basic type (with exception of type object) (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.lockObjectExpr = this.lockObjectExpr.evaluate();
        LockStatement lockStatement = new LockStatement(this.lockObjectExpr.checkIR(Expression.class));
        for (EvalStatementNode evalStatementNode : this.statements.getChildren()) {
            lockStatement.addStatement(evalStatementNode.checkIR(EvalStatement.class));
        }
        return lockStatement;
    }

    static {
        LockStatementNode.setName(LockStatementNode.class, "LockStatement");
    }
}

