/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FilterFunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.FunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.ReturnStatement;
import de.unika.ipd.grgen.ir.stmt.ReturnStatementFilter;
import de.unika.ipd.grgen.ir.stmt.ReturnStatementProcedure;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class ReturnStatementNode
extends EvalStatementNode {
    CollectNode<ExprNode> returnValueExprs;
    boolean isFilterReturn = false;
    boolean isFunctionReturn = false;

    public ReturnStatementNode(Coords coords, CollectNode<ExprNode> collectNode) {
        super(coords);
        this.returnValueExprs = collectNode;
        this.becomeParent(collectNode);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.returnValueExprs);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("return value expressions");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        Vector<Object> vector;
        if (!(declNode instanceof FunctionDeclNode || declNode instanceof ProcedureDeclNode || declNode instanceof FilterFunctionDeclNode)) {
            this.reportError("A return statement must be nested inside a function or procedure or filter (or where do you want to return from otherwise?).");
            return false;
        }
        if (declNode instanceof FilterFunctionDeclNode) {
            this.isFilterReturn = true;
            vector = new Vector();
        } else if (declNode instanceof FunctionDeclNode) {
            this.isFunctionReturn = true;
            FunctionDeclNode functionDeclNode = (FunctionDeclNode)declNode;
            vector = new Vector();
            vector.add(functionDeclNode.getResultType());
        } else {
            ProcedureDeclNode procedureDeclNode = (ProcedureDeclNode)declNode;
            vector = procedureDeclNode.getResultTypes();
        }
        return this.checkReturns(vector, declNode);
    }

    protected boolean checkReturns(Vector<TypeNode> vector, DeclNode declNode) {
        boolean bl = true;
        int n = vector.size();
        int n2 = this.returnValueExprs.size();
        for (int i = 0; i < Math.min(n, n2); ++i) {
            TypeNode typeNode;
            ExprNode exprNode = this.returnValueExprs.get(i);
            TypeNode typeNode2 = exprNode.getType();
            if (typeNode2.isCompatibleTo(typeNode = vector.get(i))) continue;
            bl = false;
            this.reportError("Cannot convert the " + (i + 1) + ". return parameter from the type " + typeNode2.getTypeName() + " to the expected type " + typeNode.getTypeName() + typeNode2.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + typeNode.toStringWithDeclarationCoordsIfCoordsAreOfInterest() + ".");
        }
        if (n2 != n) {
            bl = false;
            this.reportError("Trying to return " + n2 + " values, but expected are " + n + " values (in " + declNode + ").");
        }
        return bl;
    }

    @Override
    protected IR constructIR() {
        if (this.isFilterReturn) {
            return new ReturnStatementFilter();
        }
        if (this.isFunctionReturn) {
            ExprNode exprNode = this.returnValueExprs.get(0).evaluate();
            return new ReturnStatement(exprNode.checkIR(Expression.class));
        }
        ReturnStatementProcedure returnStatementProcedure = new ReturnStatementProcedure();
        for (ExprNode exprNode : this.returnValueExprs.getChildren()) {
            exprNode = exprNode.evaluate();
            returnStatementProcedure.addReturnValueExpr(exprNode.checkIR(Expression.class));
        }
        return returnStatementProcedure;
    }

    static {
        ReturnStatementNode.setName(ReturnStatementNode.class, "ReturnStatement");
    }
}

