/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EnumTypeNode;
import de.unika.ipd.grgen.ast.stmt.CaseStatementNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.CaseStatement;
import de.unika.ipd.grgen.ir.stmt.SwitchStatement;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class SwitchStatementNode
extends EvalStatementNode {
    private ExprNode switchExpr;
    CollectNode<CaseStatementNode> cases;

    public SwitchStatementNode(Coords coords, ExprNode exprNode, CollectNode<CaseStatementNode> collectNode) {
        super(coords);
        this.switchExpr = exprNode;
        this.becomeParent(exprNode);
        this.cases = collectNode;
        this.becomeParent(this.cases);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.switchExpr);
        vector.add(this.cases);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("switchExpr");
        vector.add("cases");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode = this.switchExpr.getType();
        if (!(typeNode.isEqual(BasicTypeNode.byteType) || typeNode.isEqual(BasicTypeNode.shortType) || typeNode.isEqual(BasicTypeNode.intType) || typeNode.isEqual(BasicTypeNode.longType) || typeNode.isEqual(BasicTypeNode.booleanType) || typeNode.isEqual(BasicTypeNode.stringType) || typeNode instanceof EnumTypeNode)) {
            this.reportError("The expression switched upon must be of type byte or short or int or long or boolean or string or enum, but is of type " + typeNode.toStringWithDeclarationCoords() + ".");
            return false;
        }
        boolean bl = false;
        for (CaseStatementNode caseStatementNode : this.cases.getChildren()) {
            ExprNode exprNode = caseStatementNode.caseConstantExpr;
            if (exprNode != null) {
                if (!(exprNode.evaluate() instanceof ConstNode)) {
                    caseStatementNode.reportError("A case statement of a switch statement expects a constant expression.");
                    return false;
                }
                TypeNode typeNode2 = exprNode.getType();
                if (typeNode2.isCompatibleTo(typeNode)) continue;
                caseStatementNode.reportError("The type " + typeNode2.toStringWithDeclarationCoords() + " of the case expression is not compatible to the type " + typeNode.toStringWithDeclarationCoords() + " of the switch expression.");
                return false;
            }
            if (bl) {
                caseStatementNode.reportError("Only one else branch allowed per switch.");
                return false;
            }
            bl = true;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.switchExpr = this.switchExpr.evaluate();
        SwitchStatement switchStatement = new SwitchStatement(this.switchExpr.checkIR(Expression.class));
        for (EvalStatementNode evalStatementNode : this.cases.getChildren()) {
            switchStatement.addStatement(evalStatementNode.checkIR(CaseStatement.class));
        }
        return switchStatement;
    }

    static {
        SwitchStatementNode.setName(SwitchStatementNode.class, "SwitchStatement");
    }
}

