/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.NestingStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.EvalStatement;
import de.unika.ipd.grgen.ir.stmt.WhileStatement;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class WhileStatementNode
extends NestingStatementNode {
    private ExprNode conditionExpr;

    public WhileStatementNode(Coords coords, ExprNode exprNode, CollectNode<EvalStatementNode> collectNode) {
        super(coords, collectNode);
        this.conditionExpr = exprNode;
        this.becomeParent(exprNode);
        this.statements = collectNode;
        this.becomeParent(this.statements);
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.conditionExpr);
        vector.add(this.statements);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("condition");
        vector.add("loopedStatements");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode = this.conditionExpr.getType();
        if (!typeNode.isEqual(BasicTypeNode.booleanType)) {
            this.conditionExpr.reportError("The condition of the while loop must be of type boolean (but is of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.conditionExpr = this.conditionExpr.evaluate();
        WhileStatement whileStatement = new WhileStatement(this.conditionExpr.checkIR(Expression.class));
        for (EvalStatementNode evalStatementNode : this.statements.getChildren()) {
            whileStatement.addStatement(evalStatementNode.checkIR(EvalStatement.class));
        }
        return whileStatement;
    }

    static {
        WhileStatementNode.setName(WhileStatementNode.class, "WhileStatement");
    }
}

