/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.EdgeTypeNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.graph.AssignmentNameof;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class AssignNameofNode
extends EvalStatementNode {
    ExprNode lhs;
    ExprNode rhs;
    int context;

    public AssignNameofNode(Coords coords, ExprNode exprNode, ExprNode exprNode2, int n) {
        super(coords);
        this.lhs = exprNode;
        this.becomeParent(this.lhs);
        this.rhs = exprNode2;
        this.becomeParent(this.rhs);
        this.context = n;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        if (this.lhs != null) {
            vector.add(this.lhs);
        }
        vector.add(this.rhs);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        if (this.lhs != null) {
            vector.add("lhs");
        }
        vector.add("rhs");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        if ((this.context & 0x80) == 0) {
            this.reportError("The nameof() assignment is not allowed in function or pattern part context.");
            return false;
        }
        TypeNode typeNode = this.rhs.getType();
        if (typeNode != BasicTypeNode.stringType) {
            this.reportError("The nameof() assignment expects as name to be assigned a value of type string (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        if (this.lhs != null) {
            TypeNode typeNode2 = this.lhs.getType();
            if (typeNode2.isEqual(BasicTypeNode.graphType)) {
                return true;
            }
            if (typeNode2 instanceof EdgeTypeNode) {
                return true;
            }
            if (typeNode2 instanceof NodeTypeNode) {
                return true;
            }
            this.reportError("The nameof() assignment expects as entity to assign to its name a value of type Node or Edge or graph (but is given a value of type " + typeNode2.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        Expression expression = null;
        if (this.lhs != null) {
            this.lhs = this.lhs.evaluate();
            expression = this.lhs.checkIR(Expression.class);
        }
        this.rhs = this.rhs.evaluate();
        return new AssignmentNameof(expression, this.rhs.checkIR(Expression.class));
    }

    static {
        AssignNameofNode.setName(AssignNameofNode.class, "Assign name");
    }
}

