/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.graph.VisitedNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.graph.Visited;
import de.unika.ipd.grgen.ir.stmt.graph.AssignmentVisited;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class AssignVisitedNode
extends EvalStatementNode {
    VisitedNode lhs;
    ExprNode rhs;
    int context;

    public AssignVisitedNode(Coords coords, VisitedNode visitedNode, ExprNode exprNode, int n) {
        super(coords);
        this.lhs = visitedNode;
        this.becomeParent(this.lhs);
        this.rhs = exprNode;
        this.becomeParent(this.rhs);
        this.context = n;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.lhs);
        vector.add(this.rhs);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("lhs");
        vector.add("rhs");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        if ((this.context & 0x80) == 0) {
            this.reportError("The visited[] assignment is not allowed in function or pattern part context.");
            return false;
        }
        TypeNode typeNode = this.rhs.getType();
        if (typeNode != BasicTypeNode.booleanType) {
            this.reportError("The visited[] assignment expects as value to be assigned a value of type boolean (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        Visited visited = this.lhs.checkIR(Visited.class);
        ExprNode exprNode = this.rhs.evaluate();
        return new AssignmentVisited(visited, exprNode.checkIR(Expression.class));
    }

    static {
        AssignVisitedNode.setName(AssignVisitedNode.class, "Assign visited");
    }
}

