/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.graph;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.model.type.NodeTypeNode;
import de.unika.ipd.grgen.ast.stmt.BuiltinProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.graph.GraphMergeProc;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class GraphMergeProcNode
extends BuiltinProcedureInvocationBaseNode {
    private ExprNode targetExpr;
    private ExprNode sourceExpr;
    private ExprNode sourceNameExpr;

    public GraphMergeProcNode(Coords coords, ExprNode exprNode, ExprNode exprNode2, ExprNode exprNode3) {
        super(coords);
        this.targetExpr = exprNode;
        this.becomeParent(exprNode);
        this.sourceExpr = exprNode2;
        this.becomeParent(exprNode2);
        this.sourceNameExpr = exprNode3;
        if (exprNode3 != null) {
            this.becomeParent(exprNode3);
        }
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.targetExpr);
        vector.add(this.sourceExpr);
        if (this.sourceNameExpr != null) {
            vector.add(this.sourceNameExpr);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("target");
        vector.add("source");
        if (this.sourceNameExpr != null) {
            vector.add("sourceName");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        return true;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode;
        TypeNode typeNode2 = this.targetExpr.getType();
        if (!(typeNode2 instanceof NodeTypeNode)) {
            this.reportError("The merge procedure expects as 1. argument (target) a value of type Node (but is given a value of type " + typeNode2.toStringWithDeclarationCoords() + ").");
            return false;
        }
        TypeNode typeNode3 = this.sourceExpr.getType();
        if (!(typeNode3 instanceof NodeTypeNode)) {
            this.reportError("The merge procedure expects as 2. argument (source) a value of type Node (but is given a value of type " + typeNode3.toStringWithDeclarationCoords() + ").");
            return false;
        }
        if (this.sourceNameExpr != null && !(typeNode = this.sourceNameExpr.getType()).equals(BasicTypeNode.stringType)) {
            this.reportError("The merge procedure expects as 3. argument (sourceName) a value of type string (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.targetExpr = this.targetExpr.evaluate();
        this.sourceExpr = this.sourceExpr.evaluate();
        if (this.sourceNameExpr != null) {
            this.sourceNameExpr = this.sourceNameExpr.evaluate();
        }
        return new GraphMergeProc(this.targetExpr.checkIR(Expression.class), this.sourceExpr.checkIR(Expression.class), this.sourceNameExpr != null ? this.sourceNameExpr.checkIR(Expression.class) : null);
    }

    static {
        GraphMergeProcNode.setName(GraphMergeProcNode.class, "graph merge procedure");
    }
}

