/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.invocation;

import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.BuiltinProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ProcedureInvocationDecisionNode;
import de.unika.ipd.grgen.ast.stmt.procenv.CommitTransactionProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.DebugAddProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.DebugEmitProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.DebugHaltProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.DebugHighlightProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.DebugRemProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.DeleteFileProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.ExportProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.PauseTransactionProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.ResumeTransactionProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.RollbackTransactionProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.StartTransactionProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.SynchronizationEnterProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.SynchronizationExitProcNode;
import de.unika.ipd.grgen.ast.stmt.procenv.SynchronizationTryEnterProcNode;
import de.unika.ipd.grgen.ast.util.ResolvingEnvironment;
import de.unika.ipd.grgen.parser.ParserEnvironment;

public class PackageProcedureInvocationDecisionNode
extends ProcedureInvocationDecisionNode {
    private String package_;

    public PackageProcedureInvocationDecisionNode(String string, IdentNode identNode, CollectNode<ExprNode> collectNode, int n, ParserEnvironment parserEnvironment) {
        super(identNode, collectNode, n, parserEnvironment);
        this.package_ = string;
    }

    @Override
    protected boolean resolveLocal() {
        ResolvingEnvironment resolvingEnvironment = new ResolvingEnvironment(this.env, error, this.getCoords());
        this.result = PackageProcedureInvocationDecisionNode.decide(this.package_ + "::" + this.procedureIdent.toString(), this.arguments, resolvingEnvironment);
        return this.result != null;
    }

    private static BuiltinProcedureInvocationBaseNode decide(String string, CollectNode<ExprNode> collectNode, ResolvingEnvironment resolvingEnvironment) {
        switch (string) {
            case "Transaction::start": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Transaction::start() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new StartTransactionProcNode(resolvingEnvironment.getCoords());
            }
            case "File::export": {
                if (collectNode.size() == 1) {
                    return new ExportProcNode(resolvingEnvironment.getCoords(), collectNode.get(0), null);
                }
                if (collectNode.size() == 2) {
                    return new ExportProcNode(resolvingEnvironment.getCoords(), collectNode.get(1), collectNode.get(0));
                }
                resolvingEnvironment.reportError("File::export() expects 1 (filepath) or 2 (graph, filepath) arguments (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "File::delete": {
                if (collectNode.size() == 1) {
                    return new DeleteFileProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
                }
                resolvingEnvironment.reportError("File::delete() expects 1 (filepath) argument (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "Debug::add": {
                if (collectNode.size() >= 1) {
                    DebugAddProcNode debugAddProcNode = new DebugAddProcNode(resolvingEnvironment.getCoords());
                    for (ExprNode exprNode : collectNode.getChildren()) {
                        debugAddProcNode.addExpression(exprNode);
                    }
                    return debugAddProcNode;
                }
                resolvingEnvironment.reportError("Debug::add() expects at least one argument, the message/computation entered (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "Debug::rem": {
                if (collectNode.size() >= 1) {
                    DebugRemProcNode debugRemProcNode = new DebugRemProcNode(resolvingEnvironment.getCoords());
                    for (ExprNode exprNode : collectNode.getChildren()) {
                        debugRemProcNode.addExpression(exprNode);
                    }
                    return debugRemProcNode;
                }
                resolvingEnvironment.reportError("Debug::rem() expects at least one argument, the message/computation left (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "Debug::emit": {
                if (collectNode.size() >= 1) {
                    DebugEmitProcNode debugEmitProcNode = new DebugEmitProcNode(resolvingEnvironment.getCoords());
                    for (ExprNode exprNode : collectNode.getChildren()) {
                        debugEmitProcNode.addExpression(exprNode);
                    }
                    return debugEmitProcNode;
                }
                resolvingEnvironment.reportError("Debug::emit() expects at least one argument, the message to report (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "Debug::halt": {
                if (collectNode.size() >= 1) {
                    DebugHaltProcNode debugHaltProcNode = new DebugHaltProcNode(resolvingEnvironment.getCoords());
                    for (ExprNode exprNode : collectNode.getChildren()) {
                        debugHaltProcNode.addExpression(exprNode);
                    }
                    return debugHaltProcNode;
                }
                resolvingEnvironment.reportError("Debug::halt() expects at least one argument, the message to report (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "Debug::highlight": {
                if (collectNode.size() % 2 == 1) {
                    DebugHighlightProcNode debugHighlightProcNode = new DebugHighlightProcNode(resolvingEnvironment.getCoords());
                    for (ExprNode exprNode : collectNode.getChildren()) {
                        debugHighlightProcNode.addExpression(exprNode);
                    }
                    return debugHighlightProcNode;
                }
                resolvingEnvironment.reportError("Debug::highlight() expects an odd number of arguments, first the message, then a series of pairs of the value to highlight followed by its annotation (given are " + collectNode.size() + " arguments).");
                return null;
            }
            case "Transaction::pause": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Transaction::pause() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new PauseTransactionProcNode(resolvingEnvironment.getCoords());
            }
            case "Transaction::resume": {
                if (collectNode.size() != 0) {
                    resolvingEnvironment.reportError("Transaction::resume() expects 0 arguments (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new ResumeTransactionProcNode(resolvingEnvironment.getCoords());
            }
            case "Transaction::commit": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Transaction::commit(transactionId) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new CommitTransactionProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "Transaction::rollback": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Transaction::rollback(transactionId) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new RollbackTransactionProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "Synchronization::enter": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Synchronization::enter(criticalSectionObject) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SynchronizationEnterProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "Synchronization::tryenter": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Synchronization::tryenter(criticalSectionObject) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SynchronizationTryEnterProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
            case "Synchronization::exit": {
                if (collectNode.size() != 1) {
                    resolvingEnvironment.reportError("Synchronization::exit(criticalSectionObject) expects 1 argument (given are " + collectNode.size() + " arguments).");
                    return null;
                }
                return new SynchronizationExitProcNode(resolvingEnvironment.getCoords(), collectNode.get(0));
            }
        }
        resolvingEnvironment.reportError("A procedure of name " + string + " is not known.");
        return null;
    }

    @Override
    protected boolean checkLocal() {
        if ((this.context & 0x80) == 0) {
            if (this.isDebugProcedure()) {
                return true;
            }
            this.reportError("A package procedure call (built-in-procedure " + this.procedureIdent + ") is not allowed in function or pattern part context.");
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmitOrDebugProcedure() {
        return this.isEmitProcedure() || this.isDebugProcedure();
    }

    @Override
    public boolean isDebugProcedure() {
        switch (this.package_ + "::" + this.procedureIdent.toString()) {
            case "Debug::add": 
            case "Debug::rem": 
            case "Debug::emit": 
            case "Debug::halt": 
            case "Debug::highlight": {
                return true;
            }
        }
        return false;
    }

    static {
        PackageProcedureInvocationDecisionNode.setName(PackageProcedureInvocationDecisionNode.class, "package procedure invocation decision");
    }
}

