/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.invocation;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.ScopeOwner;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationResolver;
import de.unika.ipd.grgen.ir.Entity;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.Procedure;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.invocation.ProcedureMethodInvocation;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Vector;

public class ProcedureMethodInvocationNode
extends ProcedureInvocationBaseNode {
    private IdentNode ownerUnresolved;
    private DeclNode owner;
    private IdentNode procedureUnresolved;
    private ProcedureDeclNode procedureDecl;
    private static final DeclarationResolver<DeclNode> ownerResolver;
    private static final DeclarationResolver<ProcedureDeclNode> resolver;

    public ProcedureMethodInvocationNode(IdentNode identNode, IdentNode identNode2, CollectNode<ExprNode> collectNode, int n) {
        super(identNode2.getCoords(), collectNode, n);
        this.ownerUnresolved = this.becomeParent(identNode);
        this.procedureUnresolved = this.becomeParent(identNode2);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.ownerUnresolved, this.owner));
        vector.add(this.getValidVersion(this.procedureUnresolved, this.procedureDecl));
        vector.add(this.arguments);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("owner");
        vector.add("procedure");
        vector.add("arguments");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        boolean bl;
        boolean bl2 = ProcedureMethodInvocationNode.fixupDefinition(this.ownerUnresolved, this.ownerUnresolved.getScope());
        if (!bl2) {
            return false;
        }
        boolean bl3 = true;
        this.owner = (DeclNode)ownerResolver.resolve(this.ownerUnresolved, this);
        bl3 = this.owner != null && bl3;
        boolean bl4 = bl = this.owner != null && this.owner.resolve();
        if (!bl) {
            return false;
        }
        if (bl && this.owner != null && (this.owner instanceof NodeDeclNode || this.owner instanceof EdgeDeclNode || this.owner instanceof VarDeclNode)) {
            TypeNode typeNode = this.owner.getDeclType();
            if (typeNode instanceof ScopeOwner) {
                ScopeOwner scopeOwner = (ScopeOwner)((Object)typeNode);
                bl2 = scopeOwner.fixupDefinition(this.procedureUnresolved);
                this.procedureDecl = (ProcedureDeclNode)resolver.resolve(this.procedureUnresolved, this);
                if (this.procedureDecl == null) {
                    this.procedureUnresolved.reportError("Unknown procedure method called. (Maybe a misspelled procedure name? Or is a function call intended? An assignment target within parenthesis denotes a procedure call, as in (var) = " + this.owner + "." + this.procedureUnresolved + "(...)).");
                    return false;
                }
                bl3 = this.procedureDecl != null && bl3;
            } else {
                this.reportError("Left hand side of '.' does not own a scope (type " + typeNode.toStringWithDeclarationCoords() + ").");
                bl3 = false;
            }
        } else {
            this.reportError("Left hand side of '.' is neither a node nor an edge nor a variable" + (this.owner != null && this.owner.getDeclType() != null ? " (type " + this.owner.getDeclType().toStringWithDeclarationCoords() + ")." : "."));
            bl3 = false;
        }
        return bl3;
    }

    @Override
    protected boolean checkLocal() {
        if ((this.context & 0x80) == 0) {
            this.reportError("Procedure method call not allowed in function or pattern part context (attempted on " + this.procedureUnresolved + ").");
            return false;
        }
        return this.checkSignatureAdhered(this.procedureDecl, this.procedureUnresolved, true);
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    public Vector<TypeNode> getType() {
        assert (this.isResolved());
        return this.procedureDecl.getResultTypes();
    }

    public int getNumReturnTypes() {
        return this.procedureDecl.resultTypesCollectNode.size();
    }

    @Override
    protected IR constructIR() {
        ProcedureMethodInvocation procedureMethodInvocation = new ProcedureMethodInvocation(this.owner.checkIR(Entity.class), this.procedureDecl.checkIR(Procedure.class));
        for (BaseNode baseNode : this.arguments.getChildren()) {
            baseNode = ((ExprNode)baseNode).evaluate();
            procedureMethodInvocation.addArgument(baseNode.checkIR(Expression.class));
        }
        for (BaseNode baseNode : this.procedureDecl.resultTypesCollectNode.getChildren()) {
            procedureMethodInvocation.addReturnType(baseNode.checkIR(Type.class));
        }
        return procedureMethodInvocation;
    }

    static {
        ProcedureMethodInvocationNode.setName(ProcedureMethodInvocationNode.class, "procedure method invocation");
        ownerResolver = new DeclarationResolver<DeclNode>(DeclNode.class);
        resolver = new DeclarationResolver<ProcedureDeclNode>(ProcedureDeclNode.class);
    }
}

