/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.invocation;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.CollectNode;
import de.unika.ipd.grgen.ast.IdentNode;
import de.unika.ipd.grgen.ast.PackageIdentNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ExternalProcedureDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclBaseNode;
import de.unika.ipd.grgen.ast.decl.executable.ProcedureDeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.stmt.invocation.ProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.util.DeclarationPairResolver;
import de.unika.ipd.grgen.ast.util.Pair;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.ExternalProcedure;
import de.unika.ipd.grgen.ir.executable.Procedure;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.invocation.ExternalProcedureInvocation;
import de.unika.ipd.grgen.ir.stmt.invocation.ProcedureInvocation;
import de.unika.ipd.grgen.ir.type.Type;
import java.util.Collection;
import java.util.Vector;

public class ProcedureOrExternalProcedureInvocationNode
extends ProcedureInvocationBaseNode {
    private IdentNode procedureOrExternalProcedureUnresolved;
    private ExternalProcedureDeclNode externalProcedureDecl;
    private ProcedureDeclNode procedureDecl;
    private static final DeclarationPairResolver<ProcedureDeclNode, ExternalProcedureDeclNode> resolver;

    public ProcedureOrExternalProcedureInvocationNode(IdentNode identNode, CollectNode<ExprNode> collectNode, int n) {
        super(identNode.getCoords(), collectNode, n);
        this.procedureOrExternalProcedureUnresolved = this.becomeParent(identNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.getValidVersion(this.procedureOrExternalProcedureUnresolved, this.procedureDecl, this.externalProcedureDecl));
        vector.add(this.arguments);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("procedure or external procedure");
        vector.add("arguments");
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        Object object;
        if (!(this.procedureOrExternalProcedureUnresolved instanceof PackageIdentNode)) {
            ProcedureOrExternalProcedureInvocationNode.fixupDefinition(this.procedureOrExternalProcedureUnresolved, this.procedureOrExternalProcedureUnresolved.getScope());
        }
        if ((object = resolver.resolve(this.procedureOrExternalProcedureUnresolved, this)) == null) {
            this.procedureOrExternalProcedureUnresolved.reportError("Unknown procedure called. (Maybe a misspelled procedure name? Or is a function call intended? An assignment target within parenthesis denotes a procedure call, as in (var) = " + this.procedureOrExternalProcedureUnresolved + "(...)).");
            return false;
        }
        this.procedureDecl = (ProcedureDeclNode)((Pair)object).fst;
        this.externalProcedureDecl = (ExternalProcedureDeclNode)((Pair)object).snd;
        return true;
    }

    @Override
    protected boolean checkLocal() {
        if ((this.context & 0x80) == 0) {
            this.reportError("Procedure call not allowed in function or pattern part context (attempted on " + this.procedureOrExternalProcedureUnresolved + ").");
            return false;
        }
        return this.checkSignatureAdhered();
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    private boolean checkSignatureAdhered() {
        ProcedureDeclBaseNode procedureDeclBaseNode = this.procedureDecl != null ? this.procedureDecl : this.externalProcedureDecl;
        return this.checkSignatureAdhered(procedureDeclBaseNode, this.procedureOrExternalProcedureUnresolved, false);
    }

    @Override
    public Vector<TypeNode> getType() {
        assert (this.isResolved());
        return this.procedureDecl != null ? this.procedureDecl.getResultTypes() : this.externalProcedureDecl.getResultTypes();
    }

    public int getNumReturnTypes() {
        if (this.procedureDecl != null) {
            return this.procedureDecl.resultTypesCollectNode.size();
        }
        return this.externalProcedureDecl.resultTypesCollectNode.size();
    }

    public IdentNode getIdentNode() {
        return this.procedureOrExternalProcedureUnresolved;
    }

    @Override
    protected IR constructIR() {
        if (this.procedureDecl != null) {
            ProcedureInvocation procedureInvocation = new ProcedureInvocation(this.procedureDecl.checkIR(Procedure.class));
            for (BaseNode baseNode : this.arguments.getChildren()) {
                baseNode = ((ExprNode)baseNode).evaluate();
                procedureInvocation.addArgument(baseNode.checkIR(Expression.class));
            }
            for (BaseNode baseNode : this.procedureDecl.resultTypesCollectNode.getChildren()) {
                procedureInvocation.addReturnType(baseNode.checkIR(Type.class));
            }
            return procedureInvocation;
        }
        ExternalProcedureInvocation externalProcedureInvocation = new ExternalProcedureInvocation(this.externalProcedureDecl.checkIR(ExternalProcedure.class));
        for (BaseNode baseNode : this.arguments.getChildren()) {
            baseNode = ((ExprNode)baseNode).evaluate();
            externalProcedureInvocation.addArgument(baseNode.checkIR(Expression.class));
        }
        for (BaseNode baseNode : this.externalProcedureDecl.resultTypesCollectNode.getChildren()) {
            externalProcedureInvocation.addReturnType(baseNode.checkIR(Type.class));
        }
        return externalProcedureInvocation;
    }

    static {
        ProcedureOrExternalProcedureInvocationNode.setName(ProcedureOrExternalProcedureInvocationNode.class, "procedure or external procedure invocation");
        resolver = new DeclarationPairResolver<ProcedureDeclNode, ExternalProcedureDeclNode>(ProcedureDeclNode.class, ExternalProcedureDeclNode.class);
    }
}

