/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.map;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.stmt.map.MapProcedureMethodInvocationBaseNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.MapTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.map.MapAddItem;
import de.unika.ipd.grgen.ir.stmt.map.MapVarAddItem;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class MapAddItemNode
extends MapProcedureMethodInvocationBaseNode {
    private ExprNode keyExpr;
    private ExprNode valueExpr;

    public MapAddItemNode(Coords coords, QualIdentNode qualIdentNode, ExprNode exprNode, ExprNode exprNode2) {
        super(coords, qualIdentNode);
        this.keyExpr = this.becomeParent(exprNode);
        this.valueExpr = this.becomeParent(exprNode2);
    }

    public MapAddItemNode(Coords coords, VarDeclNode varDeclNode, ExprNode exprNode, ExprNode exprNode2) {
        super(coords, varDeclNode);
        this.keyExpr = this.becomeParent(exprNode);
        this.valueExpr = this.becomeParent(exprNode2);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.target != null ? this.target : this.targetVar);
        vector.add(this.keyExpr);
        vector.add(this.valueExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("target");
        vector.add("keyExpr");
        vector.add("valueExpr");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        MapTypeNode mapTypeNode = this.getTargetType();
        if (this.target != null) {
            BaseNode baseNode;
            TypeNode typeNode = mapTypeNode.keyType;
            TypeNode typeNode2 = this.keyExpr.getType();
            if (!typeNode2.isEqual(typeNode)) {
                baseNode = this.keyExpr;
                this.keyExpr = this.becomeParent(this.keyExpr.adjustType(typeNode, this.getCoords()));
                if (this.keyExpr == ConstNode.getInvalid()) {
                    baseNode.reportError("The map add item procedure expects as 1. argument (key) a value of type " + typeNode.toStringWithDeclarationCoords() + " (but is given a value of type " + typeNode2.toStringWithDeclarationCoords() + ").");
                    return false;
                }
            }
            baseNode = mapTypeNode.valueType;
            TypeNode typeNode3 = this.valueExpr.getType();
            if (!typeNode3.isEqual((TypeNode)baseNode)) {
                ExprNode exprNode = this.valueExpr;
                this.valueExpr = this.becomeParent(this.valueExpr.adjustType((TypeNode)baseNode, this.getCoords()));
                if (this.valueExpr == ConstNode.getInvalid()) {
                    exprNode.reportError("The map add item procedure expects as 2. argument (value) a value of type " + baseNode.toStringWithDeclarationCoords() + " (but is given a value of type " + typeNode3.toStringWithDeclarationCoords() + ").");
                    return false;
                }
            }
        } else {
            TypeNode typeNode = mapTypeNode.keyType;
            TypeNode typeNode4 = mapTypeNode.valueType;
            return this.checkType(this.keyExpr, typeNode, "map add item procedure", "key") && this.checkType(this.valueExpr, typeNode4, "map add item procedure", "value");
        }
        return true;
    }

    @Override
    protected IR constructIR() {
        this.keyExpr = this.keyExpr.evaluate();
        this.valueExpr = this.valueExpr.evaluate();
        if (this.target != null) {
            return new MapAddItem(this.target.checkIR(Qualification.class), this.keyExpr.checkIR(Expression.class), this.valueExpr.checkIR(Expression.class));
        }
        return new MapVarAddItem(this.targetVar.checkIR(Variable.class), this.keyExpr.checkIR(Expression.class), this.valueExpr.checkIR(Expression.class));
    }

    static {
        MapAddItemNode.setName(MapAddItemNode.class, "map add item statement");
    }
}

