/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.procenv;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.stmt.BuiltinProcedureInvocationBaseNode;
import de.unika.ipd.grgen.ast.stmt.EvalStatementNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ast.type.basic.GraphTypeNode;
import de.unika.ipd.grgen.ast.type.container.ArrayTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.stmt.procenv.GetEquivalentOrAddProc;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class GetEquivalentOrAddProcNode
extends BuiltinProcedureInvocationBaseNode {
    private ExprNode subgraphExpr;
    private ExprNode subgraphArrayExpr;
    private boolean includingAttributes;
    Vector<TypeNode> returnTypes;

    public GetEquivalentOrAddProcNode(Coords coords, ExprNode exprNode, ExprNode exprNode2, boolean bl) {
        super(coords);
        this.subgraphExpr = exprNode;
        this.becomeParent(this.subgraphExpr);
        this.subgraphArrayExpr = exprNode2;
        this.becomeParent(this.subgraphArrayExpr);
        this.includingAttributes = bl;
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<ExprNode> vector = new Vector<ExprNode>();
        vector.add(this.subgraphExpr);
        vector.add(this.subgraphArrayExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("subgraphExpr");
        vector.add("subgraphArrayExpr");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        TypeNode typeNode = this.subgraphExpr.getType();
        if (!(typeNode instanceof GraphTypeNode)) {
            this.subgraphExpr.reportError("The " + this.name() + " procedure expects as 1. argument (subgraph) a value of type graph (but is given a value of type " + typeNode.toStringWithDeclarationCoords() + ").");
            return false;
        }
        TypeNode typeNode2 = this.subgraphArrayExpr.getType();
        if (!(typeNode2 instanceof ArrayTypeNode)) {
            this.subgraphArrayExpr.reportError("The " + this.name() + " procedure expects as 2. argument a value of type array<graph> (but is given a value of type " + typeNode2.toStringWithDeclarationCoords() + ").");
            return false;
        }
        TypeNode typeNode3 = ((ArrayTypeNode)typeNode2).valueType;
        if (!(typeNode3 instanceof GraphTypeNode)) {
            this.subgraphArrayExpr.reportError("The " + this.name() + " procedure expects as 2. argument a value of type array<graph> (but is given a value of type " + typeNode2.toStringWithDeclarationCoords() + ").");
            return false;
        }
        return true;
    }

    public String name() {
        return this.includingAttributes ? "getEquivalentOrAdd" : "getEquivalentStructurallyOrAdd";
    }

    @Override
    public boolean checkStatementLocal(boolean bl, DeclNode declNode, EvalStatementNode evalStatementNode) {
        return true;
    }

    @Override
    protected IR constructIR() {
        this.subgraphExpr = this.subgraphExpr.evaluate();
        this.subgraphArrayExpr = this.subgraphArrayExpr.evaluate();
        GetEquivalentOrAddProc getEquivalentOrAddProc = new GetEquivalentOrAddProc(BasicTypeNode.graphType.getType(), this.subgraphExpr.checkIR(Expression.class), this.subgraphArrayExpr.checkIR(Expression.class), this.includingAttributes);
        return getEquivalentOrAddProc;
    }

    @Override
    public Vector<TypeNode> getType() {
        if (this.returnTypes == null) {
            this.returnTypes = new Vector();
            this.returnTypes.add(BasicTypeNode.graphType);
        }
        return this.returnTypes;
    }

    static {
        GetEquivalentOrAddProcNode.setName(GetEquivalentOrAddProcNode.class, "get equivalent or add procedure");
    }
}

