/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.stmt.set;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.ConstNode;
import de.unika.ipd.grgen.ast.expr.ExprNode;
import de.unika.ipd.grgen.ast.expr.QualIdentNode;
import de.unika.ipd.grgen.ast.stmt.set.SetProcedureMethodInvocationBaseNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.container.SetTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.expr.Expression;
import de.unika.ipd.grgen.ir.expr.Qualification;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.stmt.set.SetRemoveItem;
import de.unika.ipd.grgen.ir.stmt.set.SetVarRemoveItem;
import de.unika.ipd.grgen.parser.Coords;
import java.util.Collection;
import java.util.Vector;

public class SetRemoveItemNode
extends SetProcedureMethodInvocationBaseNode {
    private ExprNode valueExpr;

    public SetRemoveItemNode(Coords coords, QualIdentNode qualIdentNode, ExprNode exprNode) {
        super(coords, qualIdentNode);
        this.valueExpr = this.becomeParent(exprNode);
    }

    public SetRemoveItemNode(Coords coords, VarDeclNode varDeclNode, ExprNode exprNode) {
        super(coords, varDeclNode);
        this.valueExpr = this.becomeParent(exprNode);
    }

    @Override
    public Collection<? extends BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        vector.add(this.target != null ? this.target : this.targetVar);
        vector.add(this.valueExpr);
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        vector.add("target");
        vector.add("valueExpr");
        return vector;
    }

    @Override
    protected boolean checkLocal() {
        SetTypeNode setTypeNode = this.getTargetType();
        if (this.target != null) {
            TypeNode typeNode = setTypeNode.valueType;
            TypeNode typeNode2 = this.valueExpr.getType();
            if (!typeNode2.isEqual(typeNode)) {
                ExprNode exprNode = this.valueExpr;
                this.valueExpr = this.becomeParent(this.valueExpr.adjustType(typeNode, this.getCoords()));
                if (this.valueExpr == ConstNode.getInvalid()) {
                    exprNode.reportError("The set rem item procedure expects as argument (value) a value of type " + typeNode.toStringWithDeclarationCoords() + " (but is given a value of type " + typeNode2.toStringWithDeclarationCoords() + ").");
                    return false;
                }
            }
            return true;
        }
        TypeNode typeNode = setTypeNode.valueType;
        return this.checkType(this.valueExpr, typeNode, "value", "set rem item procedure");
    }

    @Override
    protected IR constructIR() {
        this.valueExpr = this.valueExpr.evaluate();
        if (this.target != null) {
            return new SetRemoveItem(this.target.checkIR(Qualification.class), this.valueExpr.checkIR(Expression.class));
        }
        return new SetVarRemoveItem(this.targetVar.checkIR(Variable.class), this.valueExpr.checkIR(Expression.class));
    }

    static {
        SetRemoveItemNode.setName(SetRemoveItemNode.class, "set remove item statement");
    }
}

