/*
 * Decompiled with CFR 0.152.
 */
package de.unika.ipd.grgen.ast.type;

import de.unika.ipd.grgen.ast.BaseNode;
import de.unika.ipd.grgen.ast.MatchClassAutoNode;
import de.unika.ipd.grgen.ast.MatchClassFilterCharacter;
import de.unika.ipd.grgen.ast.decl.DeclNode;
import de.unika.ipd.grgen.ast.decl.executable.MatchClassFilterAutoGeneratedDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.MatchClassFilterFunctionDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorDeclNode;
import de.unika.ipd.grgen.ast.decl.executable.OperatorEvaluator;
import de.unika.ipd.grgen.ast.decl.pattern.DummyNodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.EdgeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.NodeDeclNode;
import de.unika.ipd.grgen.ast.decl.pattern.VarDeclNode;
import de.unika.ipd.grgen.ast.expr.array.ArrayAccumulationMethodNode;
import de.unika.ipd.grgen.ast.pattern.ConnectionCharacter;
import de.unika.ipd.grgen.ast.pattern.ConnectionNode;
import de.unika.ipd.grgen.ast.pattern.PatternGraphLhsNode;
import de.unika.ipd.grgen.ast.type.MatchTypeNode;
import de.unika.ipd.grgen.ast.type.TypeNode;
import de.unika.ipd.grgen.ast.type.basic.BasicTypeNode;
import de.unika.ipd.grgen.ir.IR;
import de.unika.ipd.grgen.ir.executable.MatchClassFilterAutoGenerated;
import de.unika.ipd.grgen.ir.executable.MatchClassFilterFunction;
import de.unika.ipd.grgen.ir.pattern.PatternGraphLhs;
import de.unika.ipd.grgen.ir.pattern.Variable;
import de.unika.ipd.grgen.ir.type.DefinedMatchType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class DefinedMatchTypeNode
extends MatchTypeNode {
    protected ArrayList<MatchClassFilterCharacter> filters;
    private PatternGraphLhsNode pattern;
    private MatchClassAutoNode auto;

    public DefinedMatchTypeNode(PatternGraphLhsNode patternGraphLhsNode) {
        this.pattern = patternGraphLhsNode;
        this.becomeParent(this.pattern);
    }

    public DefinedMatchTypeNode(MatchClassAutoNode matchClassAutoNode) {
        this.auto = matchClassAutoNode;
        this.becomeParent(this.auto);
    }

    @Override
    public String getTypeName() {
        return "match<class " + this.getIdentNode().toString() + ">";
    }

    public void addFilters(ArrayList<MatchClassFilterCharacter> arrayList) {
        this.filters = arrayList;
    }

    public Collection<BaseNode> getChildren() {
        Vector<BaseNode> vector = new Vector<BaseNode>();
        if (this.pattern != null) {
            vector.add(this.pattern);
        }
        if (this.auto != null) {
            vector.add(this.auto);
        }
        return vector;
    }

    @Override
    public Collection<String> getChildrenNames() {
        Vector<String> vector = new Vector<String>();
        if (this.pattern != null) {
            vector.add("pattern");
        }
        if (this.auto != null) {
            vector.add("auto");
        }
        return vector;
    }

    @Override
    protected boolean resolveLocal() {
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.EQ, BasicTypeNode.booleanType, this, this, OperatorEvaluator.nullEvaluator);
        OperatorDeclNode.makeBinOp(OperatorDeclNode.Operator.NE, BasicTypeNode.booleanType, this, this, OperatorEvaluator.nullEvaluator);
        boolean bl = true;
        if (this.pattern == null && (bl = this.auto.resolve())) {
            this.pattern = this.becomeParent(this.auto.getPatternGraph());
            this.auto.fillPatternGraph(this.pattern);
        }
        boolean bl2 = true;
        for (MatchClassFilterCharacter matchClassFilterCharacter : this.filters) {
            if (matchClassFilterCharacter instanceof MatchClassFilterFunctionDeclNode) {
                bl2 &= ((MatchClassFilterFunctionDeclNode)matchClassFilterCharacter).resolve();
                continue;
            }
            bl2 &= ((MatchClassFilterAutoGeneratedDeclNode)matchClassFilterCharacter).resolve();
        }
        return bl & bl2;
    }

    @Override
    protected boolean checkLocal() {
        for (ConnectionCharacter connectionCharacter : this.pattern.getConnections()) {
            ConnectionNode connectionNode;
            if (!(connectionCharacter instanceof ConnectionNode) || (connectionNode = (ConnectionNode)connectionCharacter).getSrc() instanceof DummyNodeDeclNode && connectionNode.getTgt() instanceof DummyNodeDeclNode) continue;
            connectionNode.reportError("Only single edge declarations without linked nodes allowed in match classes (but " + connectionNode.getEdge().getIdentNode() + " comes with linked nodes).");
        }
        return this.checkFilters();
    }

    private boolean checkFilters() {
        boolean bl = true;
        for (MatchClassFilterCharacter object2 : this.filters) {
            if (object2 instanceof MatchClassFilterFunctionDeclNode) {
                bl &= ((MatchClassFilterFunctionDeclNode)object2).check();
                continue;
            }
            bl &= ((MatchClassFilterAutoGeneratedDeclNode)object2).check();
        }
        boolean bl2 = true;
        HashSet<String> hashSet = new HashSet<String>();
        for (MatchClassFilterCharacter matchClassFilterCharacter : this.filters) {
            if (!(matchClassFilterCharacter instanceof MatchClassFilterAutoGeneratedDeclNode)) continue;
            MatchClassFilterAutoGeneratedDeclNode matchClassFilterAutoGeneratedDeclNode = (MatchClassFilterAutoGeneratedDeclNode)matchClassFilterCharacter;
            String string = matchClassFilterAutoGeneratedDeclNode.getFilterNameWithEntitySuffix();
            if (hashSet.contains(string)) {
                this.getIdentNode().reportError("The filter " + string + " was already declared, only one declaration is admissible.");
                bl2 = false;
            } else {
                hashSet.add(string);
            }
            bl2 &= this.checkAutoGeneratedFilter(matchClassFilterAutoGeneratedDeclNode);
        }
        return bl & bl2;
    }

    private boolean checkAutoGeneratedFilter(MatchClassFilterAutoGeneratedDeclNode matchClassFilterAutoGeneratedDeclNode) {
        String string = matchClassFilterAutoGeneratedDeclNode.getFilterNameWithEntitySuffix();
        switch (matchClassFilterAutoGeneratedDeclNode.name) {
            case "orderAscendingBy": 
            case "orderDescendingBy": {
                boolean bl = true;
                for (String string2 : matchClassFilterAutoGeneratedDeclNode.entities) {
                    bl &= this.pattern.checkFilterVariable(this.getIdentNode(), matchClassFilterAutoGeneratedDeclNode.name, string2);
                }
                return bl;
            }
            case "keepOneForEach": 
            case "groupBy": 
            case "keepSameAsFirst": 
            case "keepSameAsLast": {
                boolean bl = true;
                for (String string3 : matchClassFilterAutoGeneratedDeclNode.entities) {
                    bl &= this.pattern.checkFilterEntity(this.getIdentNode(), matchClassFilterAutoGeneratedDeclNode.name, string3);
                }
                if (matchClassFilterAutoGeneratedDeclNode.entities.size() != 1) {
                    this.getIdentNode().reportError("The filter " + string + " must be declared with exactly one variable, but is declared with " + matchClassFilterAutoGeneratedDeclNode.entities.size() + " variables (in " + string + " for " + this.pattern.nameOfGraph + ").");
                    bl = false;
                }
                return bl;
            }
            case "keepOneForEachAccumulateBy": {
                if (matchClassFilterAutoGeneratedDeclNode.entities.size() != 3) {
                    this.getIdentNode().reportError("The filter " + matchClassFilterAutoGeneratedDeclNode.getFilterName() + " must be declared with exactly one variable, one accumulation variable, and one accumulation method, but is declared with " + matchClassFilterAutoGeneratedDeclNode.entities.size() + " entities (in " + string + " for " + this.pattern.nameOfGraph + ").");
                    return false;
                }
                if (matchClassFilterAutoGeneratedDeclNode.entities.get(0).equals(matchClassFilterAutoGeneratedDeclNode.entities.get(1))) {
                    this.getIdentNode().reportError("The accumulation variable must be different from the variable " + matchClassFilterAutoGeneratedDeclNode.entities.get(0) + " (in " + string + " for " + this.pattern.nameOfGraph + ").");
                    return false;
                }
                boolean bl = this.pattern.checkFilterEntity(this.getIdentNode(), string, matchClassFilterAutoGeneratedDeclNode.entities.get(0));
                if (!bl) {
                    return false;
                }
                ArrayAccumulationMethodNode arrayAccumulationMethodNode = ArrayAccumulationMethodNode.getArrayMethodNode(matchClassFilterAutoGeneratedDeclNode.entities.get(2));
                if (arrayAccumulationMethodNode == null) {
                    this.getIdentNode().reportError("The array accumulation method " + matchClassFilterAutoGeneratedDeclNode.entities.get(2) + " is not known (in " + string + " for " + this.pattern.nameOfGraph + ").");
                    return false;
                }
                VarDeclNode varDeclNode = this.tryGetVar(matchClassFilterAutoGeneratedDeclNode.entities.get(1));
                if (varDeclNode == null) {
                    this.getIdentNode().reportError("Unknown accumulation variable " + matchClassFilterAutoGeneratedDeclNode.entities.get(1) + " (in " + string + " for " + this.pattern.nameOfGraph + ").");
                    return false;
                }
                TypeNode typeNode = varDeclNode.getDeclType();
                if (!arrayAccumulationMethodNode.isValidTargetTypeOfAccumulation(typeNode)) {
                    this.getIdentNode().reportError("The array accumulation method " + matchClassFilterAutoGeneratedDeclNode.entities.get(2) + " is not applicable to the type " + typeNode.getTypeName() + " of the accumulation variable " + matchClassFilterAutoGeneratedDeclNode.entities.get(1) + " / its result cannot be assigned to the accumulation variable. (Allowed are: " + arrayAccumulationMethodNode.getValidTargetTypesOfAccumulation() + ") (in " + string + " for " + this.pattern.nameOfGraph + ").");
                    return false;
                }
                return true;
            }
        }
        assert (false);
        return false;
    }

    public NodeDeclNode tryGetNode(String string) {
        return this.pattern.tryGetNode(string);
    }

    public EdgeDeclNode tryGetEdge(String string) {
        return this.pattern.tryGetEdge(string);
    }

    public VarDeclNode tryGetVar(String string) {
        return this.pattern.tryGetVar(string);
    }

    @Override
    public DeclNode tryGetMember(String string) {
        NodeDeclNode nodeDeclNode = this.pattern.tryGetNode(string);
        if (nodeDeclNode != null) {
            return nodeDeclNode;
        }
        EdgeDeclNode edgeDeclNode = this.pattern.tryGetEdge(string);
        if (edgeDeclNode != null) {
            return edgeDeclNode;
        }
        return this.pattern.tryGetVar(string);
    }

    public Set<NodeDeclNode> getNodes() {
        HashSet<NodeDeclNode> hashSet = new HashSet<NodeDeclNode>();
        for (NodeDeclNode nodeDeclNode : this.pattern.getNodes()) {
            if (nodeDeclNode instanceof DummyNodeDeclNode) continue;
            hashSet.add(nodeDeclNode);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<EdgeDeclNode> getEdges() {
        return this.pattern.getEdges();
    }

    public Set<VarDeclNode> getVariables() {
        HashSet<VarDeclNode> hashSet = new HashSet<VarDeclNode>(this.pattern.getDefVariablesToBeYieldedTo().getChildren());
        for (DeclNode declNode : this.pattern.getParamDecls()) {
            if (!(declNode instanceof VarDeclNode)) continue;
            VarDeclNode varDeclNode = (VarDeclNode)declNode;
            hashSet.add(varDeclNode);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public Set<DeclNode> getEntities() {
        return this.pattern.getEntities();
    }

    public DefinedMatchType getDefinedMatchType() {
        return this.checkIR(DefinedMatchType.class);
    }

    @Override
    protected IR constructIR() {
        if (this.isIRAlreadySet()) {
            return (DefinedMatchType)this.getIR();
        }
        PatternGraphLhs patternGraphLhs = this.pattern.getPatternGraph();
        for (DeclNode object : this.pattern.getParamDecls()) {
            if (!(object instanceof VarDeclNode)) continue;
            VarDeclNode varDeclNode = (VarDeclNode)object;
            patternGraphLhs.addVariable(varDeclNode.checkIR(Variable.class));
        }
        DefinedMatchType definedMatchType = new DefinedMatchType(this.getIdentNode().toString(), this.getIdentNode().getIdent(), patternGraphLhs);
        this.setIR(definedMatchType);
        for (MatchClassFilterCharacter matchClassFilterCharacter : this.filters) {
            if (matchClassFilterCharacter instanceof MatchClassFilterFunctionDeclNode) {
                ((MatchClassFilterFunctionDeclNode)matchClassFilterCharacter).checkIR(MatchClassFilterFunction.class);
                continue;
            }
            ((MatchClassFilterAutoGeneratedDeclNode)matchClassFilterCharacter).checkIR(MatchClassFilterAutoGenerated.class);
        }
        return definedMatchType;
    }

    static {
        DefinedMatchTypeNode.setName(DefinedMatchTypeNode.class, "defined match type");
    }
}

